/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import org.redkale.net.AsyncConnection;
import org.redkale.util.ByteArray;

abstract class ReplyCompletionHandler
implements CompletionHandler<Integer, ByteBuffer> {
    protected final ByteArray out = new ByteArray();
    protected final AsyncConnection conn;

    public ReplyCompletionHandler(AsyncConnection conn) {
        this.conn = conn;
    }

    protected byte[] readBytes(ByteBuffer buffer) throws IOException {
        this.readLine(buffer);
        return this.out.getBytesAndClear();
    }

    protected String readString(ByteBuffer buffer) throws IOException {
        this.readLine(buffer);
        return this.out.toStringAndClear(null);
    }

    protected int readInt(ByteBuffer buffer) throws IOException {
        return (int)this.readLong(buffer);
    }

    protected long readLong(ByteBuffer buffer) throws IOException {
        this.readLine(buffer);
        int start = 0;
        if (this.out.get(0) == 36) {
            start = 1;
        }
        boolean negative = this.out.get(start) == 45;
        long value = negative ? 0L : (long)(this.out.get(start) - 48);
        for (int i = 1 + start; i < this.out.size(); ++i) {
            value = value * 10L + (long)(this.out.get(i) - 48);
        }
        this.out.clear();
        return negative ? -value : value;
    }

    private void readLine(ByteBuffer buffer) throws IOException {
        byte lasted;
        boolean has = buffer.hasRemaining();
        byte by = lasted = has ? buffer.get() : (byte)0;
        if (lasted == 10 && !this.out.isEmpty() && this.out.getLastByte() == 13) {
            this.out.removeLastByte();
            buffer.get();
            return;
        }
        if (has) {
            this.out.write(lasted);
        }
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 10 && lasted == 13) {
                this.out.removeLastByte();
                return;
            }
            lasted = b;
            this.out.write(lasted);
        }
        buffer.clear();
        this.conn.read(buffer);
        buffer.flip();
        this.readLine(buffer);
    }
}

