/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.cache;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.redkale.convert.bson.BsonByteBufferWriter;
import org.redkale.convert.json.JsonConvert;
import org.redkale.convert.json.JsonFactory;
import org.redkale.net.Transport;
import org.redkale.net.TransportFactory;
import org.redkale.service.AbstractService;
import org.redkale.service.Local;
import org.redkale.service.Service;
import org.redkale.source.CacheSource;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.Resourcable;
import org.redkale.util.ResourceType;
import org.redkale.util.TypeToken;
import org.redkalex.cache.ReplyCompletionHandler;

@Local
@AutoLoad(value=false)
@ResourceType(value=CacheSource.class)
public class RedisCacheSource<V>
extends AbstractService
implements CacheSource<V>,
Service,
AutoCloseable,
Resourcable {
    protected static final String UTF8_NAME = "UTF-8";
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final byte DOLLAR_BYTE = 36;
    protected static final byte ASTERISK_BYTE = 42;
    protected static final byte PLUS_BYTE = 43;
    protected static final byte MINUS_BYTE = 45;
    protected static final byte COLON_BYTE = 58;
    private final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    @Resource
    protected JsonConvert defaultConvert;
    @Resource(name="$_convert")
    protected JsonConvert convert;
    protected Type objValueType = String.class;
    protected Map<SocketAddress, byte[]> passwords;
    protected Transport transport;

    public void init(AnyValue conf) {
        String storeValueStr;
        AnyValue prop;
        if (this.convert == null) {
            this.convert = this.defaultConvert;
        }
        if (conf == null) {
            conf = new AnyValue.DefaultAnyValue();
        }
        if ((prop = conf.getAnyValue("properties")) != null && (storeValueStr = prop.getValue("value-type")) != null) {
            try {
                this.initValueType(Thread.currentThread().getContextClassLoader().loadClass(storeValueStr));
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, this.getClass().getSimpleName() + " load key & value store class (" + storeValueStr + ") error", e);
            }
        }
        int bufferCapacity = conf.getIntValue("bufferCapacity", 8192);
        int bufferPoolSize = conf.getIntValue("bufferPoolSize", Runtime.getRuntime().availableProcessors() * 8);
        int threads = conf.getIntValue("threads", Runtime.getRuntime().availableProcessors() * 8);
        int readTimeoutSeconds = conf.getIntValue("readTimeoutSeconds", TransportFactory.DEFAULT_READTIMEOUTSECONDS);
        int writeTimeoutSeconds = conf.getIntValue("writeTimeoutSeconds", TransportFactory.DEFAULT_WRITETIMEOUTSECONDS);
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        HashMap<SocketAddress, byte[]> passwords0 = new HashMap<SocketAddress, byte[]>();
        for (AnyValue node : conf.getAnyValues("node")) {
            InetSocketAddress addr = new InetSocketAddress(node.getValue("addr"), node.getIntValue("port"));
            addresses.add(addr);
            String password = node.getValue("password", "").trim();
            if (password.isEmpty()) continue;
            passwords0.put(addr, password.getBytes(UTF8));
        }
        if (!passwords0.isEmpty()) {
            this.passwords = passwords0;
        }
        TransportFactory transportFactory = TransportFactory.create((int)threads, (int)bufferPoolSize, (int)bufferCapacity, (int)readTimeoutSeconds, (int)writeTimeoutSeconds);
        this.transport = transportFactory.createTransportTCP("Redis-Transport", null, addresses);
    }

    public void updateRemoteAddresses(Collection<InetSocketAddress> addresses) {
        this.transport.updateRemoteAddresses(addresses);
    }

    public final void initValueType(Type valueType) {
        this.objValueType = valueType == null ? String.class : valueType;
    }

    public final void initTransient(boolean flag) {
    }

    public final String getType() {
        return "redis";
    }

    public static void main(String[] args) throws Exception {
        AnyValue.DefaultAnyValue conf = new AnyValue.DefaultAnyValue();
        conf.addValue("node", (AnyValue)new AnyValue.DefaultAnyValue().addValue("addr", "127.0.0.1").addValue("port", "6379"));
        RedisCacheSource<String> source = new RedisCacheSource<String>();
        source.defaultConvert = JsonFactory.root().getConvert();
        source.initValueType((Type)((Object)String.class));
        source.init((AnyValue)conf);
        InetSocketAddress addr = new InetSocketAddress("127.0.0.1", 7788);
        System.out.println("------------------------------------");
        source.remove("key1");
        source.remove("key2");
        source.remove("300");
        source.set(1000, "key1", "value1");
        source.set("key1", "value1");
        source.setString("keystr1", "strvalue1");
        source.setLong("keylong1", 333L);
        source.set("300", "4000");
        source.getAndRefresh("key1", 3500);
        System.out.println("[\u6709\u503c] 300 GET : " + source.get("300"));
        System.out.println("[\u6709\u503c] key1 GET : " + source.get("key1"));
        System.out.println("[\u65e0\u503c] key2 GET : " + source.get("key2"));
        System.out.println("[\u6709\u503c] keystr1 GET : " + source.getString("keystr1"));
        System.out.println("[\u6709\u503c] keylong1 GET : " + source.getLong("keylong1", 0L));
        System.out.println("[\u6709\u503c] key1 EXISTS : " + source.exists("key1"));
        System.out.println("[\u65e0\u503c] key2 EXISTS : " + source.exists("key2"));
        source.remove("keys3");
        source.appendListItem("keys3", "vals1");
        source.appendListItem("keys3", "vals2");
        System.out.println("-------- keys3 \u8ffd\u52a0\u4e86\u4e24\u4e2a\u503c --------");
        System.out.println("[\u4e24\u503c] keys3 VALUES : " + source.getCollection("keys3"));
        System.out.println("[\u6709\u503c] keys3 EXISTS : " + source.exists("keys3"));
        source.removeListItem("keys3", "vals1");
        System.out.println("[\u4e00\u503c] keys3 VALUES : " + source.getCollection("keys3"));
        source.getCollectionAndRefresh("keys3", 3000);
        source.remove("sets3");
        source.remove("sets4");
        source.appendSetItem("sets3", "setvals1");
        source.appendSetItem("sets3", "setvals2");
        source.appendSetItem("sets3", "setvals1");
        source.appendSetItem("sets4", "setvals2");
        source.appendSetItem("sets4", "setvals1");
        System.out.println("[\u4e24\u503c] sets3 VALUES : " + source.getCollection("sets3"));
        System.out.println("[\u6709\u503c] sets3 EXISTS : " + source.exists("sets3"));
        System.out.println("[\u6709\u503c] sets3-setvals2 EXISTSITEM : " + source.existsSetItem("sets3", "setvals2"));
        System.out.println("[\u6709\u503c] sets3-setvals3 EXISTSITEM : " + source.existsSetItem("sets3", "setvals3"));
        source.removeSetItem("sets3", "setvals1");
        System.out.println("[\u4e00\u503c] sets3 VALUES : " + source.getCollection("sets3"));
        System.out.println("sets3 \u5927\u5c0f : " + source.getCollectionSize("sets3"));
        System.out.println("all keys: " + source.queryKeys());
        System.out.println("key startkeys: " + source.queryKeysStartsWith("key"));
        System.out.println("newnum \u503c : " + source.incr("newnum"));
        System.out.println("newnum \u503c : " + source.decr("newnum"));
        System.out.println("sets3&sets4:  " + source.getStringCollectionMap(true, "sets3", "sets4"));
        System.out.println("------------------------------------");
        source.set("myaddr", (Type)((Object)InetSocketAddress.class), (Object)addr);
        System.out.println("myaddr:  " + source.get("myaddr", (Type)((Object)InetSocketAddress.class)));
        source.remove("myaddrs");
        source.remove("myaddrs2");
        source.appendSetItem("myaddrs", (Type)((Object)InetSocketAddress.class), (Object)new InetSocketAddress("127.0.0.1", 7788));
        source.appendSetItem("myaddrs", (Type)((Object)InetSocketAddress.class), (Object)new InetSocketAddress("127.0.0.1", 7799));
        System.out.println("myaddrs:  " + source.getCollection("myaddrs", (Type)((Object)InetSocketAddress.class)));
        source.removeSetItem("myaddrs", (Type)((Object)InetSocketAddress.class), (Object)new InetSocketAddress("127.0.0.1", 7788));
        System.out.println("myaddrs:  " + source.getCollection("myaddrs", (Type)((Object)InetSocketAddress.class)));
        source.appendSetItem("myaddrs2", (Type)((Object)InetSocketAddress.class), (Object)new InetSocketAddress("127.0.0.1", 7788));
        source.appendSetItem("myaddrs2", (Type)((Object)InetSocketAddress.class), (Object)new InetSocketAddress("127.0.0.1", 7799));
        System.out.println("myaddrs&myaddrs2:  " + source.getCollectionMap(true, (Type)((Object)InetSocketAddress.class), "myaddrs", "myaddrs2"));
        System.out.println("------------------------------------");
        source.remove("myaddrs");
        Type mapType = new TypeToken<Map<String, Integer>>(){}.getType();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        source.set("mapvals", mapType, map);
        System.out.println("mapvals:  " + source.get("mapvals", mapType));
        System.out.println("------------------------------------");
    }

    @Override
    public void close() throws Exception {
        this.destroy(null);
    }

    public String resourceName() {
        Resource res = this.getClass().getAnnotation(Resource.class);
        return res == null ? null : res.name();
    }

    public void destroy(AnyValue conf) {
        if (this.transport != null) {
            this.transport.close();
        }
    }

    public CompletableFuture<Boolean> existsAsync(String key) {
        return this.send("EXISTS", null, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public boolean exists(String key) {
        return this.existsAsync(key).join();
    }

    public CompletableFuture<V> getAsync(String key) {
        return this.send("GET", CacheSource.CacheEntryType.OBJECT, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public <T> CompletableFuture<T> getAsync(String key, Type type) {
        return this.send("GET", CacheSource.CacheEntryType.OBJECT, type, key, new byte[][]{key.getBytes(UTF8)});
    }

    public CompletableFuture<String> getStringAsync(String key) {
        return this.send("GET", CacheSource.CacheEntryType.STRING, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public CompletableFuture<Long> getLongAsync(String key, long defValue) {
        return this.send("GET", CacheSource.CacheEntryType.LONG, (Type)null, key, new byte[][]{key.getBytes(UTF8)}).thenApplyAsync(v -> v == null ? Long.valueOf(defValue) : v);
    }

    public V get(String key) {
        return this.getAsync(key).join();
    }

    public <T> T get(String key, Type type) {
        return this.getAsync(key, type).join();
    }

    public String getString(String key) {
        return this.getStringAsync(key).join();
    }

    public long getLong(String key, long defValue) {
        return this.getLongAsync(key, defValue).join();
    }

    public CompletableFuture<V> getAndRefreshAsync(String key, int expireSeconds) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getAsync(key));
    }

    public <T> CompletableFuture<T> getAndRefreshAsync(String key, int expireSeconds, Type type) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getAsync(key, type));
    }

    public V getAndRefresh(String key, int expireSeconds) {
        return this.getAndRefreshAsync(key, expireSeconds).join();
    }

    public <T> T getAndRefresh(String key, int expireSeconds, Type type) {
        return this.getAndRefreshAsync(key, expireSeconds, type).join();
    }

    public CompletableFuture<String> getStringAndRefreshAsync(String key, int expireSeconds) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getAsync(key));
    }

    public String getStringAndRefresh(String key, int expireSeconds) {
        return this.getStringAndRefreshAsync(key, expireSeconds).join();
    }

    public CompletableFuture<Long> getLongAndRefreshAsync(String key, int expireSeconds, long defValue) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getLongAsync(key, defValue));
    }

    public long getLongAndRefresh(String key, int expireSeconds, long defValue) {
        return this.getLongAndRefreshAsync(key, expireSeconds, defValue).join();
    }

    public CompletableFuture<Void> refreshAsync(String key, int expireSeconds) {
        return this.setExpireSecondsAsync(key, expireSeconds);
    }

    public void refresh(String key, int expireSeconds) {
        this.setExpireSeconds(key, expireSeconds);
    }

    public CompletableFuture<Void> setAsync(String key, V value) {
        return this.send("SET", CacheSource.CacheEntryType.OBJECT, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, null, value));
    }

    public <T> CompletableFuture<Void> setAsync(String key, Type type, T value) {
        return this.send("SET", CacheSource.CacheEntryType.OBJECT, type, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, type, value));
    }

    public void set(String key, V value) {
        this.setAsync(key, value).join();
    }

    public <T> void set(String key, Type type, T value) {
        this.setAsync(key, type, value).join();
    }

    public CompletableFuture<Void> setStringAsync(String key, String value) {
        return this.send("SET", CacheSource.CacheEntryType.STRING, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.STRING, null, value));
    }

    public void setString(String key, String value) {
        this.setStringAsync(key, value).join();
    }

    public CompletableFuture<Void> setLongAsync(String key, long value) {
        return this.send("SET", CacheSource.CacheEntryType.LONG, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.LONG, null, value));
    }

    public void setLong(String key, long value) {
        this.setLongAsync(key, value).join();
    }

    public CompletableFuture<Void> setAsync(int expireSeconds, String key, V value) {
        return this.setAsync(key, value).thenCompose(v -> this.setExpireSecondsAsync(key, expireSeconds));
    }

    public <T> CompletableFuture<Void> setAsync(int expireSeconds, String key, Type type, T value) {
        return this.setAsync(key, type, value).thenCompose(v -> this.setExpireSecondsAsync(key, expireSeconds));
    }

    public void set(int expireSeconds, String key, V value) {
        this.setAsync(expireSeconds, key, value).join();
    }

    public <T> void set(int expireSeconds, String key, Type type, T value) {
        this.setAsync(expireSeconds, key, type, value).join();
    }

    public CompletableFuture<Void> setStringAsync(int expireSeconds, String key, String value) {
        return this.setStringAsync(key, value).thenCompose(v -> this.setExpireSecondsAsync(key, expireSeconds));
    }

    public void setString(int expireSeconds, String key, String value) {
        this.setStringAsync(expireSeconds, key, value).join();
    }

    public CompletableFuture<Void> setLongAsync(int expireSeconds, String key, long value) {
        return this.setLongAsync(key, value).thenCompose(v -> this.setExpireSecondsAsync(key, expireSeconds));
    }

    public void setLong(int expireSeconds, String key, long value) {
        this.setLongAsync(expireSeconds, key, value).join();
    }

    public CompletableFuture<Void> setExpireSecondsAsync(String key, int expireSeconds) {
        return this.send("EXPIRE", null, (Type)null, key, key.getBytes(UTF8), String.valueOf(expireSeconds).getBytes(UTF8));
    }

    public void setExpireSeconds(String key, int expireSeconds) {
        this.setExpireSecondsAsync(key, expireSeconds).join();
    }

    public CompletableFuture<Void> removeAsync(String key) {
        return this.send("DEL", null, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public void remove(String key) {
        this.removeAsync(key).join();
    }

    public long incr(String key) {
        return this.incrAsync(key).join();
    }

    public CompletableFuture<Long> incrAsync(String key) {
        return this.send("INCR", CacheSource.CacheEntryType.ATOMIC, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public long incr(String key, long num) {
        return this.incrAsync(key, num).join();
    }

    public CompletableFuture<Long> incrAsync(String key, long num) {
        return this.send("INCRBY", CacheSource.CacheEntryType.ATOMIC, (Type)null, key, key.getBytes(UTF8), String.valueOf(num).getBytes(UTF8));
    }

    public long decr(String key) {
        return this.decrAsync(key).join();
    }

    public CompletableFuture<Long> decrAsync(String key) {
        return this.send("DECR", CacheSource.CacheEntryType.ATOMIC, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public long decr(String key, long num) {
        return this.decrAsync(key, num).join();
    }

    public CompletableFuture<Long> decrAsync(String key, long num) {
        return this.send("DECRBY", CacheSource.CacheEntryType.ATOMIC, (Type)null, key, key.getBytes(UTF8), String.valueOf(num).getBytes(UTF8));
    }

    public CompletableFuture<Integer> getCollectionSizeAsync(String key) {
        return this.send("OBJECT", null, (Type)null, key, "ENCODING".getBytes(UTF8), key.getBytes(UTF8)).thenCompose(t -> {
            if (t == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (new String((byte[])t).contains("list")) {
                return this.send("LLEN", null, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
            }
            return this.send("SCARD", null, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
        });
    }

    public int getCollectionSize(String key) {
        return this.getCollectionSizeAsync(key).join();
    }

    public CompletableFuture<Collection<V>> getCollectionAsync(String key) {
        return this.send("OBJECT", null, (Type)null, key, "ENCODING".getBytes(UTF8), key.getBytes(UTF8)).thenCompose(t -> {
            if (t == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (new String((byte[])t).contains("list")) {
                return this.send("LRANGE", CacheSource.CacheEntryType.OBJECT, (Type)null, false, key, (byte[][])new byte[][]{key.getBytes(UTF8), {48}, {45, 49}});
            }
            return this.send("SMEMBERS", CacheSource.CacheEntryType.OBJECT, (Type)null, true, key, (byte[][])new byte[][]{key.getBytes(UTF8)});
        });
    }

    public <T> CompletableFuture<Collection<T>> getCollectionAsync(String key, Type componentType) {
        return this.send("OBJECT", null, componentType, key, "ENCODING".getBytes(UTF8), key.getBytes(UTF8)).thenCompose(t -> {
            if (t == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (new String((byte[])t).contains("list")) {
                return this.send("LRANGE", CacheSource.CacheEntryType.OBJECT, componentType, false, key, (byte[][])new byte[][]{key.getBytes(UTF8), {48}, {45, 49}});
            }
            return this.send("SMEMBERS", CacheSource.CacheEntryType.OBJECT, componentType, true, key, (byte[][])new byte[][]{key.getBytes(UTF8)});
        });
    }

    public <T> CompletableFuture<Map<String, Collection<T>>> getCollectionMapAsync(boolean set, Type componentType, String ... keys) {
        CompletableFuture rsFuture = new CompletableFuture();
        HashMap map = new HashMap();
        CompletableFuture[] futures = new CompletableFuture[keys.length];
        if (!set) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                futures[i] = this.send("LRANGE", CacheSource.CacheEntryType.OBJECT, componentType, false, key, (byte[][])new byte[][]{key.getBytes(UTF8), {48}, {45, 49}}).thenAccept(c -> {
                    if (c != null) {
                        Map map2 = map;
                        synchronized (map2) {
                            map.put(key, (Collection)((Object)c));
                        }
                    }
                });
            }
        } else {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                futures[i] = this.send("SMEMBERS", CacheSource.CacheEntryType.OBJECT, componentType, true, key, (byte[][])new byte[][]{key.getBytes(UTF8)}).thenAccept(c -> {
                    if (c != null) {
                        Map map2 = map;
                        synchronized (map2) {
                            map.put(key, (Collection)((Object)c));
                        }
                    }
                });
            }
        }
        CompletableFuture.allOf(futures).whenComplete((w, e) -> {
            if (e != null) {
                rsFuture.completeExceptionally((Throwable)e);
            } else {
                rsFuture.complete(map);
            }
        });
        return rsFuture;
    }

    public Collection<V> getCollection(String key) {
        return this.getCollectionAsync(key).join();
    }

    public <T> Collection<T> getCollection(String key, Type componentType) {
        return this.getCollectionAsync(key, componentType).join();
    }

    public <T> Map<String, Collection<T>> getCollectionMap(boolean set, Type componentType, String ... keys) {
        return this.getCollectionMapAsync(set, componentType, keys).join();
    }

    public CompletableFuture<Collection<String>> getStringCollectionAsync(String key) {
        return this.send("OBJECT", null, (Type)null, key, "ENCODING".getBytes(UTF8), key.getBytes(UTF8)).thenCompose(t -> {
            if (t == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (new String((byte[])t).contains("list")) {
                return this.send("LRANGE", CacheSource.CacheEntryType.STRING, (Type)null, false, key, (byte[][])new byte[][]{key.getBytes(UTF8), {48}, {45, 49}});
            }
            return this.send("SMEMBERS", CacheSource.CacheEntryType.STRING, (Type)null, true, key, (byte[][])new byte[][]{key.getBytes(UTF8)});
        });
    }

    public CompletableFuture<Map<String, Collection<String>>> getStringCollectionMapAsync(boolean set, String ... keys) {
        CompletableFuture<Map<String, Collection<String>>> rsFuture = new CompletableFuture<Map<String, Collection<String>>>();
        HashMap map = new HashMap();
        CompletableFuture[] futures = new CompletableFuture[keys.length];
        if (!set) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                futures[i] = this.send("LRANGE", CacheSource.CacheEntryType.STRING, (Type)null, false, key, (byte[][])new byte[][]{key.getBytes(UTF8), {48}, {45, 49}}).thenAccept(c -> {
                    if (c != null) {
                        Map map2 = map;
                        synchronized (map2) {
                            map.put(key, (Collection)((Object)c));
                        }
                    }
                });
            }
        } else {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                futures[i] = this.send("SMEMBERS", CacheSource.CacheEntryType.STRING, (Type)null, true, key, (byte[][])new byte[][]{key.getBytes(UTF8)}).thenAccept(c -> {
                    if (c != null) {
                        Map map2 = map;
                        synchronized (map2) {
                            map.put(key, (Collection)((Object)c));
                        }
                    }
                });
            }
        }
        CompletableFuture.allOf(futures).whenComplete((w, e) -> {
            if (e != null) {
                rsFuture.completeExceptionally((Throwable)e);
            } else {
                rsFuture.complete(map);
            }
        });
        return rsFuture;
    }

    public Collection<String> getStringCollection(String key) {
        return this.getStringCollectionAsync(key).join();
    }

    public Map<String, Collection<String>> getStringCollectionMap(boolean set, String ... keys) {
        return this.getStringCollectionMapAsync(set, keys).join();
    }

    public CompletableFuture<Collection<Long>> getLongCollectionAsync(String key) {
        return this.send("OBJECT", null, (Type)null, key, "ENCODING".getBytes(UTF8), key.getBytes(UTF8)).thenCompose(t -> {
            if (t == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (new String((byte[])t).contains("list")) {
                return this.send("LRANGE", CacheSource.CacheEntryType.LONG, (Type)null, false, key, (byte[][])new byte[][]{key.getBytes(UTF8), {48}, {45, 49}});
            }
            return this.send("SMEMBERS", CacheSource.CacheEntryType.LONG, (Type)null, true, key, (byte[][])new byte[][]{key.getBytes(UTF8)});
        });
    }

    public CompletableFuture<Map<String, Collection<Long>>> getLongCollectionMapAsync(boolean set, String ... keys) {
        CompletableFuture<Map<String, Collection<Long>>> rsFuture = new CompletableFuture<Map<String, Collection<Long>>>();
        HashMap map = new HashMap();
        CompletableFuture[] futures = new CompletableFuture[keys.length];
        if (!set) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                futures[i] = this.send("LRANGE", CacheSource.CacheEntryType.LONG, (Type)null, false, key, (byte[][])new byte[][]{key.getBytes(UTF8), {48}, {45, 49}}).thenAccept(c -> {
                    if (c != null) {
                        Map map2 = map;
                        synchronized (map2) {
                            map.put(key, (Collection)((Object)c));
                        }
                    }
                });
            }
        } else {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                futures[i] = this.send("SMEMBERS", CacheSource.CacheEntryType.LONG, (Type)null, true, key, (byte[][])new byte[][]{key.getBytes(UTF8)}).thenAccept(c -> {
                    if (c != null) {
                        Map map2 = map;
                        synchronized (map2) {
                            map.put(key, (Collection)((Object)c));
                        }
                    }
                });
            }
        }
        CompletableFuture.allOf(futures).whenComplete((w, e) -> {
            if (e != null) {
                rsFuture.completeExceptionally((Throwable)e);
            } else {
                rsFuture.complete(map);
            }
        });
        return rsFuture;
    }

    public Collection<Long> getLongCollection(String key) {
        return this.getLongCollectionAsync(key).join();
    }

    public Map<String, Collection<Long>> getLongCollectionMap(boolean set, String ... keys) {
        return this.getLongCollectionMapAsync(set, keys).join();
    }

    public CompletableFuture<Collection<V>> getCollectionAndRefreshAsync(String key, int expireSeconds) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getCollectionAsync(key));
    }

    public <T> CompletableFuture<Collection<T>> getCollectionAndRefreshAsync(String key, int expireSeconds, Type componentType) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getCollectionAsync(key, componentType));
    }

    public Collection<V> getCollectionAndRefresh(String key, int expireSeconds) {
        return this.getCollectionAndRefreshAsync(key, expireSeconds).join();
    }

    public <T> Collection<T> getCollectionAndRefresh(String key, int expireSeconds, Type componentType) {
        return this.getCollectionAndRefreshAsync(key, expireSeconds, componentType).join();
    }

    public CompletableFuture<Collection<String>> getStringCollectionAndRefreshAsync(String key, int expireSeconds) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getStringCollectionAsync(key));
    }

    public Collection<String> getStringCollectionAndRefresh(String key, int expireSeconds) {
        return this.getStringCollectionAndRefreshAsync(key, expireSeconds).join();
    }

    public CompletableFuture<Collection<Long>> getLongCollectionAndRefreshAsync(String key, int expireSeconds) {
        return this.refreshAsync(key, expireSeconds).thenCompose(v -> this.getLongCollectionAsync(key));
    }

    public Collection<Long> getLongCollectionAndRefresh(String key, int expireSeconds) {
        return this.getLongCollectionAndRefreshAsync(key, expireSeconds).join();
    }

    public boolean existsSetItem(String key, V value) {
        return this.existsSetItemAsync(key, value).join();
    }

    public <T> boolean existsSetItem(String key, Type componentType, T value) {
        return this.existsSetItemAsync(key, componentType, value).join();
    }

    public CompletableFuture<Boolean> existsSetItemAsync(String key, V value) {
        return this.send("SISMEMBER", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, null, value));
    }

    public <T> CompletableFuture<Boolean> existsSetItemAsync(String key, Type componentType, T value) {
        return this.send("SISMEMBER", null, componentType, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, componentType, value));
    }

    public boolean existsStringSetItem(String key, String value) {
        return this.existsStringSetItemAsync(key, value).join();
    }

    public CompletableFuture<Boolean> existsStringSetItemAsync(String key, String value) {
        return this.send("SISMEMBER", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.STRING, null, value));
    }

    public boolean existsLongSetItem(String key, long value) {
        return this.existsLongSetItemAsync(key, value).join();
    }

    public CompletableFuture<Boolean> existsLongSetItemAsync(String key, long value) {
        return this.send("SISMEMBER", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.LONG, null, value));
    }

    public CompletableFuture<Void> appendListItemAsync(String key, V value) {
        return this.send("RPUSH", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, null, value));
    }

    public <T> CompletableFuture<Void> appendListItemAsync(String key, Type componentType, T value) {
        return this.send("RPUSH", null, componentType, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, componentType, value));
    }

    public void appendListItem(String key, V value) {
        this.appendListItemAsync(key, value).join();
    }

    public <T> void appendListItem(String key, Type componentType, T value) {
        this.appendListItemAsync(key, componentType, value).join();
    }

    public CompletableFuture<Void> appendStringListItemAsync(String key, String value) {
        return this.send("RPUSH", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.STRING, null, value));
    }

    public void appendStringListItem(String key, String value) {
        this.appendStringListItemAsync(key, value).join();
    }

    public CompletableFuture<Void> appendLongListItemAsync(String key, long value) {
        return this.send("RPUSH", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.LONG, null, value));
    }

    public void appendLongListItem(String key, long value) {
        this.appendLongListItemAsync(key, value).join();
    }

    public CompletableFuture<Void> removeListItemAsync(String key, V value) {
        return this.send("LREM", null, (Type)null, key, key.getBytes(UTF8), {48}, this.formatValue(CacheSource.CacheEntryType.OBJECT, null, value));
    }

    public <T> CompletableFuture<Void> removeListItemAsync(String key, Type componentType, T value) {
        return this.send("LREM", null, componentType, key, key.getBytes(UTF8), {48}, this.formatValue(CacheSource.CacheEntryType.OBJECT, componentType, value));
    }

    public void removeListItem(String key, V value) {
        this.removeListItemAsync(key, value).join();
    }

    public <T> void removeListItem(String key, Type componentType, T value) {
        this.removeListItemAsync(key, componentType, value).join();
    }

    public CompletableFuture<Void> removeStringListItemAsync(String key, String value) {
        return this.send("LREM", null, (Type)null, key, key.getBytes(UTF8), {48}, this.formatValue(CacheSource.CacheEntryType.STRING, null, value));
    }

    public void removeStringListItem(String key, String value) {
        this.removeStringListItemAsync(key, value).join();
    }

    public CompletableFuture<Void> removeLongListItemAsync(String key, long value) {
        return this.send("LREM", null, (Type)null, key, key.getBytes(UTF8), {48}, this.formatValue(CacheSource.CacheEntryType.LONG, null, value));
    }

    public void removeLongListItem(String key, long value) {
        this.removeLongListItemAsync(key, value).join();
    }

    public CompletableFuture<Void> appendSetItemAsync(String key, V value) {
        return this.send("SADD", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, null, value));
    }

    public <T> CompletableFuture<Void> appendSetItemAsync(String key, Type componentType, T value) {
        return this.send("SADD", null, componentType, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, componentType, value));
    }

    public void appendSetItem(String key, V value) {
        this.appendSetItemAsync(key, value).join();
    }

    public <T> void appendSetItem(String key, Type componentType, T value) {
        this.appendSetItemAsync(key, componentType, value).join();
    }

    public CompletableFuture<Void> appendStringSetItemAsync(String key, String value) {
        return this.send("SADD", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.STRING, null, value));
    }

    public void appendStringSetItem(String key, String value) {
        this.appendStringSetItemAsync(key, value).join();
    }

    public CompletableFuture<Void> appendLongSetItemAsync(String key, long value) {
        return this.send("SADD", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.LONG, null, value));
    }

    public void appendLongSetItem(String key, long value) {
        this.appendLongSetItemAsync(key, value).join();
    }

    public CompletableFuture<Void> removeSetItemAsync(String key, V value) {
        return this.send("SREM", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, null, value));
    }

    public <T> CompletableFuture<Void> removeSetItemAsync(String key, Type componentType, T value) {
        return this.send("SREM", null, componentType, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.OBJECT, componentType, value));
    }

    public void removeSetItem(String key, V value) {
        this.removeSetItemAsync(key, value).join();
    }

    public <T> void removeSetItem(String key, Type componentType, T value) {
        this.removeSetItemAsync(key, componentType, value).join();
    }

    public CompletableFuture<Void> removeStringSetItemAsync(String key, String value) {
        return this.send("SREM", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.STRING, null, value));
    }

    public void removeStringSetItem(String key, String value) {
        this.removeStringSetItemAsync(key, value).join();
    }

    public CompletableFuture<Void> removeLongSetItemAsync(String key, long value) {
        return this.send("SREM", null, (Type)null, key, key.getBytes(UTF8), this.formatValue(CacheSource.CacheEntryType.LONG, null, value));
    }

    public void removeLongSetItem(String key, long value) {
        this.removeLongSetItemAsync(key, value).join();
    }

    public List<String> queryKeys() {
        return this.queryKeysAsync().join();
    }

    public List<String> queryKeysStartsWith(String startsWith) {
        return this.queryKeysStartsWithAsync(startsWith).join();
    }

    public List<String> queryKeysEndsWith(String endsWith) {
        return this.queryKeysEndsWithAsync(endsWith).join();
    }

    public CompletableFuture<List<String>> queryKeysAsync() {
        return this.send("KEYS", null, (Type)null, "*", new byte[][]{{42}});
    }

    public CompletableFuture<List<String>> queryKeysStartsWithAsync(String startsWith) {
        if (startsWith == null) {
            return this.queryKeysAsync();
        }
        String key = startsWith + "*";
        return this.send("KEYS", null, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public CompletableFuture<List<String>> queryKeysEndsWithAsync(String endsWith) {
        if (endsWith == null) {
            return this.queryKeysAsync();
        }
        String key = "*" + endsWith;
        return this.send("KEYS", null, (Type)null, key, new byte[][]{key.getBytes(UTF8)});
    }

    public int getKeySize() {
        return this.getKeySizeAsync().join();
    }

    public CompletableFuture<Integer> getKeySizeAsync() {
        return this.send("DBSIZE", null, (Type)null, null, new byte[0][]);
    }

    public List<CacheSource.CacheEntry<Object>> queryList() {
        return this.queryListAsync().join();
    }

    public CompletableFuture<List<CacheSource.CacheEntry<Object>>> queryListAsync() {
        return CompletableFuture.completedFuture(new ArrayList());
    }

    private byte[] formatValue(CacheSource.CacheEntryType cacheType, Type resultType, Object value) {
        if (value == null) {
            return "null".getBytes(UTF8);
        }
        if (cacheType == CacheSource.CacheEntryType.LONG || cacheType == CacheSource.CacheEntryType.ATOMIC) {
            return String.valueOf(value).getBytes(UTF8);
        }
        if (cacheType == CacheSource.CacheEntryType.STRING) {
            return this.convert.convertTo(String.class, value).getBytes(UTF8);
        }
        return this.convert.convertTo(resultType == null ? this.objValueType : resultType, value).getBytes(UTF8);
    }

    private CompletableFuture<Serializable> send(String command, CacheSource.CacheEntryType cacheType, Type resultType, String key, byte[] ... args) {
        return this.send(command, cacheType, resultType, false, key, args);
    }

    private CompletableFuture<Serializable> send(String command, CacheSource.CacheEntryType cacheType, Type resultType, boolean set, String key, byte[] ... args) {
        return this.send(null, command, cacheType, resultType, set, key, args);
    }

    private CompletableFuture<Serializable> send(final CompletionHandler callback, final String command, final CacheSource.CacheEntryType cacheType, final Type resultType, final boolean set, final String key, byte[] ... args) {
        BsonByteBufferWriter writer = new BsonByteBufferWriter(this.transport.getBufferSupplier());
        writer.writeTo((byte)42);
        writer.writeTo(String.valueOf(args.length + 1).getBytes(UTF8));
        writer.writeTo(new byte[]{13, 10});
        writer.writeTo((byte)36);
        writer.writeTo(String.valueOf(command.length()).getBytes(UTF8));
        writer.writeTo(new byte[]{13, 10});
        writer.writeTo(command.getBytes(UTF8));
        writer.writeTo(new byte[]{13, 10});
        for (byte[] arg : args) {
            writer.writeTo((byte)36);
            writer.writeTo(String.valueOf(arg.length).getBytes(UTF8));
            writer.writeTo(new byte[]{13, 10});
            writer.writeTo(arg);
            writer.writeTo(new byte[]{13, 10});
        }
        ByteBuffer[] buffers = writer.toBuffers();
        final CompletableFuture<Serializable> future = callback == null ? new CompletableFuture<Serializable>() : null;
        CompletionStage connFuture = this.transport.pollConnection(null);
        if (this.passwords != null) {
            connFuture = connFuture.thenCompose(conn -> {
                if (conn.getSubobject() != null) {
                    return CompletableFuture.completedFuture(conn);
                }
                byte[] password = this.passwords.get(conn.getRemoteAddress());
                if (password == null) {
                    return CompletableFuture.completedFuture(conn);
                }
                final CompletableFuture rsfuture = new CompletableFuture();
                try {
                    BsonByteBufferWriter authwriter = new BsonByteBufferWriter(this.transport.getBufferSupplier());
                    authwriter.writeTo((byte)42);
                    authwriter.writeTo((byte)50);
                    authwriter.writeTo(new byte[]{13, 10});
                    authwriter.writeTo((byte)36);
                    authwriter.writeTo((byte)52);
                    authwriter.writeTo(new byte[]{13, 10});
                    authwriter.writeTo("AUTH".getBytes(UTF8));
                    authwriter.writeTo(new byte[]{13, 10});
                    authwriter.writeTo((byte)36);
                    authwriter.writeTo(String.valueOf(password.length).getBytes(UTF8));
                    authwriter.writeTo(new byte[]{13, 10});
                    authwriter.writeTo(password);
                    authwriter.writeTo(new byte[]{13, 10});
                    ByteBuffer[] authbuffers = authwriter.toBuffers();
                    conn.write(authbuffers, (Object)authbuffers, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer[]>(){

                        @Override
                        public void completed(Integer result, ByteBuffer[] attachments) {
                            int index = -1;
                            try {
                                for (int i = 0; i < attachments.length; ++i) {
                                    if (attachments[i].hasRemaining()) {
                                        index = i;
                                        break;
                                    }
                                    RedisCacheSource.this.transport.offerBuffer(attachments[i]);
                                }
                                if (index == 0) {
                                    conn.write(attachments, (Object)attachments, (CompletionHandler)this);
                                    return;
                                }
                                if (index > 0) {
                                    ByteBuffer[] newattachs = new ByteBuffer[attachments.length - index];
                                    System.arraycopy(attachments, index, newattachs, 0, newattachs.length);
                                    conn.write(newattachs, (Object)newattachs, (CompletionHandler)this);
                                    return;
                                }
                                conn.read((CompletionHandler)new ReplyCompletionHandler(conn){

                                    @Override
                                    public void completed(Integer result, ByteBuffer buffer) {
                                        buffer.flip();
                                        try {
                                            byte sign = buffer.get();
                                            if (sign == 43) {
                                                byte[] bs = this.readBytes(buffer);
                                                if ("OK".equalsIgnoreCase(new String(bs))) {
                                                    this.conn.setSubobject((Object)"authed");
                                                    rsfuture.complete(this.conn);
                                                } else {
                                                    RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                    rsfuture.completeExceptionally(new RuntimeException("command : " + command + ", error: " + bs));
                                                }
                                            } else if (sign == 45) {
                                                String bs = this.readString(buffer);
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                rsfuture.completeExceptionally(new RuntimeException("command : " + command + ", error: " + bs));
                                            } else {
                                                String exstr = "Unknown reply: " + (char)sign;
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                rsfuture.completeExceptionally(new RuntimeException(exstr));
                                            }
                                        }
                                        catch (Exception e) {
                                            this.failed((Throwable)e, buffer);
                                        }
                                    }

                                    @Override
                                    public void failed(Throwable exc, ByteBuffer buffer) {
                                        this.conn.offerBuffer(buffer);
                                        RedisCacheSource.this.transport.offerConnection(true, this.conn);
                                        rsfuture.completeExceptionally(exc);
                                    }
                                });
                            }
                            catch (Exception e) {
                                this.failed((Throwable)e, attachments);
                            }
                        }

                        @Override
                        public void failed(Throwable exc, ByteBuffer[] attachments) {
                            RedisCacheSource.this.transport.offerConnection(true, conn);
                            rsfuture.completeExceptionally(exc);
                        }
                    });
                }
                catch (Exception e) {
                    rsfuture.completeExceptionally(e);
                }
                return rsfuture;
            });
        }
        connFuture.whenComplete((conn, ex) -> {
            if (ex != null) {
                this.transport.offerBuffer(buffers);
                if (future == null) {
                    callback.failed((Throwable)ex, null);
                } else {
                    future.completeExceptionally((Throwable)ex);
                }
                return;
            }
            conn.write(buffers, (Object)buffers, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer[]>(){

                @Override
                public void completed(Integer result, final ByteBuffer[] attachments) {
                    int index = -1;
                    try {
                        for (int i = 0; i < attachments.length; ++i) {
                            if (attachments[i].hasRemaining()) {
                                index = i;
                                break;
                            }
                            RedisCacheSource.this.transport.offerBuffer(attachments[i]);
                        }
                        if (index == 0) {
                            conn.write(attachments, (Object)attachments, (CompletionHandler)this);
                            return;
                        }
                        if (index > 0) {
                            ByteBuffer[] newattachs = new ByteBuffer[attachments.length - index];
                            System.arraycopy(attachments, index, newattachs, 0, newattachs.length);
                            conn.write(newattachs, (Object)newattachs, (CompletionHandler)this);
                            return;
                        }
                        conn.read((CompletionHandler)new ReplyCompletionHandler(conn){

                            @Override
                            public void completed(Integer result, ByteBuffer buffer) {
                                buffer.flip();
                                try {
                                    byte sign = buffer.get();
                                    if (sign == 43) {
                                        byte[] bs = this.readBytes(buffer);
                                        if (future == null) {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            callback.completed(null, key);
                                        } else {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            future.complete("SET".equals(command) ? null : bs);
                                        }
                                    } else if (sign == 45) {
                                        String bs = this.readString(buffer);
                                        if (future == null) {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            callback.failed(new RuntimeException(bs), key);
                                        } else {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            future.completeExceptionally(new RuntimeException("command : " + command + ", error: " + bs));
                                        }
                                    } else if (sign == 58) {
                                        long rs = this.readLong(buffer);
                                        if (future == null) {
                                            if (command.startsWith("INCR") || command.startsWith("DECR")) {
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                callback.completed(rs, key);
                                            } else {
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                callback.completed("EXISTS".equals(command) || "SISMEMBER".equals(command) ? (Comparable<Boolean>)Boolean.valueOf(rs > 0L) : (Comparable<Boolean>)("LLEN".equals(command) || "SCARD".equals(command) || "DBSIZE".equals(command) ? Integer.valueOf((int)rs) : null), key);
                                            }
                                        } else if (command.startsWith("INCR") || command.startsWith("DECR")) {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            future.complete(rs);
                                        } else {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            future.complete("EXISTS".equals(command) || "SISMEMBER".equals(command) ? (Comparable<Boolean>)Boolean.valueOf(rs > 0L) : (Comparable<Boolean>)("LLEN".equals(command) || "SCARD".equals(command) || "DBSIZE".equals(command) ? Integer.valueOf((int)rs) : null));
                                        }
                                    } else if (sign == 36) {
                                        Class ct;
                                        byte[] rs;
                                        long val = this.readLong(buffer);
                                        byte[] byArray = rs = val <= 0L ? null : this.readBytes(buffer);
                                        Class clazz = cacheType == CacheSource.CacheEntryType.LONG ? Long.TYPE : (cacheType == CacheSource.CacheEntryType.STRING ? String.class : (ct = resultType == null ? RedisCacheSource.this.objValueType : resultType));
                                        if (future == null) {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            callback.completed("GET".equals(command) || rs == null ? RedisCacheSource.this.convert.convertFrom(ct, new String(rs, UTF8)) : null, key);
                                        } else {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            future.complete("GET".equals(command) ? (Object)((Serializable)RedisCacheSource.this.convert.convertFrom(ct, rs == null ? null : new String(rs, UTF8))) : rs);
                                        }
                                    } else if (sign == 42) {
                                        int len = this.readInt(buffer);
                                        if (len < 0) {
                                            if (future == null) {
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                callback.completed(null, key);
                                            } else {
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                future.complete(null);
                                            }
                                        } else {
                                            AbstractCollection rs = set ? new HashSet() : new ArrayList();
                                            boolean keys = "KEYS".equals(command);
                                            Class<Long> ct = cacheType == CacheSource.CacheEntryType.LONG ? Long.TYPE : (cacheType == CacheSource.CacheEntryType.STRING ? String.class : (resultType == null ? RedisCacheSource.this.objValueType : resultType));
                                            for (int i = 0; i < len; ++i) {
                                                if (this.readInt(buffer) <= 0) continue;
                                                rs.add(keys ? new String(this.readBytes(buffer), UTF8) : RedisCacheSource.this.convert.convertFrom(ct, new String(this.readBytes(buffer), UTF8)));
                                            }
                                            if (future == null) {
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                callback.completed(rs, key);
                                            } else {
                                                RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                                future.complete((Serializable)((Object)rs));
                                            }
                                        }
                                    } else {
                                        String exstr = "Unknown reply: " + (char)sign;
                                        if (future == null) {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            callback.failed(new RuntimeException(exstr), key);
                                        } else {
                                            RedisCacheSource.this.transport.offerConnection(false, this.conn);
                                            future.completeExceptionally(new RuntimeException(exstr));
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    this.failed((Throwable)e, buffer);
                                }
                            }

                            @Override
                            public void failed(Throwable exc, ByteBuffer attachment) {
                                this.conn.offerBuffer(attachment);
                                RedisCacheSource.this.transport.offerConnection(true, this.conn);
                                if (future == null) {
                                    callback.failed(exc, attachments);
                                } else {
                                    future.completeExceptionally(exc);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        this.failed((Throwable)e, attachments);
                    }
                }

                @Override
                public void failed(Throwable exc, ByteBuffer[] attachments) {
                    RedisCacheSource.this.transport.offerConnection(true, conn);
                    if (future == null) {
                        callback.failed(exc, attachments);
                    } else {
                        future.completeExceptionally(exc);
                    }
                }
            });
        });
        return future;
    }
}

