/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.apns;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redkale.convert.json.JsonConvert;
import org.redkale.service.Local;
import org.redkale.service.Service;
import org.redkale.util.AnyValue;
import org.redkale.util.AutoLoad;
import org.redkale.util.ResourceListener;
import org.redkale.util.Utility;
import org.redkalex.apns.ApnsMessage;

@Local
@AutoLoad(value=false)
public class ApnsService
implements Service {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    @Resource
    protected JsonConvert convert;
    @Resource(name="APP_HOME")
    protected File home;
    @Resource(name="property.apns.certpwd")
    protected String apnscertpwd = "1";
    @Resource(name="property.apns.certpath")
    protected String apnscertpath = "apnspushdev_cert.p12";
    @Resource(name="property.apns.certbase64")
    protected String apnscertbase64 = "";
    @Resource(name="property.apns.pushaddr")
    protected String apnspushaddr = "gateway.push.apple.com";
    @Resource(name="property.apns.pushport")
    protected int apnspushport = 2195;
    @Resource(name="property.apns.buffersize")
    protected int apnsbuffersize = 4096;
    private boolean inited = false;
    private CountDownLatch cdl = new CountDownLatch(1);
    private SSLSocketFactory sslFactory;

    @ResourceListener
    void changeResource(String name, Object newVal, Object oldVal) {
        this.logger.info("@Resource = " + name + " resource changed:  newVal = " + newVal + ", oldVal = " + oldVal);
        this.inited = false;
        this.cdl = new CountDownLatch(1);
        this.init(null);
    }

    public void init(AnyValue conf) {
        if (this.convert == null) {
            this.convert = JsonConvert.root();
        }
        new Thread(){
            {
                this.setDaemon(true);
                this.setPriority(10);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    File file;
                    File file2 = file = ApnsService.this.apnscertpath.indexOf(47) == 0 || ApnsService.this.apnscertpath.indexOf(58) > 0 ? new File(ApnsService.this.apnscertpath) : new File(ApnsService.this.home, "conf/" + ApnsService.this.apnscertpath);
                    InputStream in = ApnsService.this.apnscertbase64 != null && !ApnsService.this.apnscertbase64.isEmpty() ? new ByteArrayInputStream(Base64.getDecoder().decode(ApnsService.this.apnscertbase64)) : (file.isFile() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/META-INF/" + ApnsService.this.apnscertpath));
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    KeyManagerFactory kf = null;
                    if (in != null) {
                        ks.load(in, ApnsService.this.apnscertpwd.toCharArray());
                        in.close();
                        kf = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        kf.init(ks, ApnsService.this.apnscertpwd.toCharArray());
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init((KeyStore)null);
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(kf == null ? new KeyManager[]{} : kf.getKeyManagers(), tmf.getTrustManagers(), null);
                    ApnsService.this.sslFactory = context.getSocketFactory();
                }
                catch (Exception e) {
                    ApnsService.this.logger.log(Level.SEVERE, this.getClass().getSimpleName() + " init SSLContext error", e);
                }
                finally {
                    ApnsService.this.inited = true;
                    ApnsService.this.cdl.countDown();
                }
            }
        }.start();
    }

    public void destroy(AnyValue conf) {
    }

    private Socket getPushSocket() throws IOException {
        if (!this.inited) {
            try {
                this.cdl.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Socket pushSocket = this.sslFactory.createSocket(this.apnspushaddr, this.apnspushport);
        pushSocket.setTcpNoDelay(true);
        return pushSocket;
    }

    public void pushApnsMessage(ApnsMessage message) throws IOException {
        byte[] tokens = Utility.hexToBin((String)message.getToken().replaceAll("\\s+", ""));
        ByteBuffer buffer = ByteBuffer.allocate(this.apnsbuffersize);
        buffer.put((byte)2);
        buffer.putInt(0);
        buffer.put((byte)1);
        buffer.putShort((short)tokens.length);
        buffer.put(tokens);
        buffer.put((byte)2);
        byte[] payload = message.getPayload().toString().getBytes(UTF8);
        buffer.putShort((short)payload.length);
        buffer.put(payload);
        if (message.getIdentifier() > 0) {
            buffer.put((byte)3);
            buffer.putShort((short)4);
            buffer.putInt(message.getIdentifier());
        }
        if (message.getExpiredate() > 0) {
            buffer.put((byte)4);
            buffer.putShort((short)4);
            buffer.putInt(message.getExpiredate());
        }
        buffer.put((byte)5);
        buffer.putShort((short)1);
        buffer.put((byte)message.getPriority());
        int pos = buffer.position();
        buffer.position(1);
        buffer.putInt(pos - 5);
        buffer.position(pos);
        buffer.flip();
        Socket socket = this.getPushSocket();
        socket.getOutputStream().write(buffer.array(), 0, buffer.remaining());
        socket.close();
    }
}

