/*
 * Decompiled with CFR 0.152.
 */
package org.redkalex.apns;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.redkale.convert.json.JsonFactory;

public class ApnsPayload {
    private static final Pattern regex = Pattern.compile("\"");
    private String alertTitle;
    private String alertBody;
    private String alertTitleLocKey;
    private String[] alertTitleLocArgs;
    private String alertActionLocKey;
    private String alertLocKey;
    private String[] alertLocArgs;
    private String alertLaunchImage;
    private int contentAvailable;
    private String alert;
    private int badge;
    private String sound;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public ApnsPayload() {
    }

    public ApnsPayload(String alert, int badge) {
        this.alert = alert;
        this.badge = badge;
    }

    public ApnsPayload(String title, String body, int badge) {
        this.alertTitle = title;
        this.alertBody = body;
        this.badge = badge;
    }

    public void putAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> map) {
        if (map != null) {
            this.attributes.putAll(map);
        }
    }

    public String toString() {
        StringBuilder alertsb = new StringBuilder();
        if (this.alert != null) {
            alertsb.append('\"').append(regex.matcher(this.alert).replaceAll("\\\"")).append('\"');
        } else {
            boolean first;
            alertsb.append('{');
            if (this.alertTitle != null) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"title\":\"").append(regex.matcher(this.alertTitle).replaceAll("\\\"")).append('\"');
            }
            if (this.alertBody != null) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"body\":\"").append(regex.matcher(this.alertBody).replaceAll("\\\"")).append('\"');
            }
            if (this.alertTitleLocKey != null) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"title-loc-key\":\"").append(regex.matcher(this.alertTitleLocKey).replaceAll("\\\"")).append('\"');
            }
            if (this.alertTitleLocArgs != null && this.alertTitleLocArgs.length > 0) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"title-loc-args\":[");
                first = true;
                for (String str : this.alertTitleLocArgs) {
                    if (!first) {
                        alertsb.append(',');
                    }
                    alertsb.append('\"').append(regex.matcher(str).replaceAll("\\\"")).append('\"');
                    first = false;
                }
                alertsb.append(']');
            }
            if (this.alertActionLocKey != null) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"action-loc-key\":\"").append(regex.matcher(this.alertActionLocKey).replaceAll("\\\"")).append('\"');
            }
            if (this.alertLocKey != null) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"loc-key\":\"").append(regex.matcher(this.alertLocKey).replaceAll("\\\"")).append('\"');
            }
            if (this.alertLocArgs != null && this.alertLocArgs.length > 0) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"loc-args\":[");
                first = true;
                for (String str : this.alertLocArgs) {
                    if (!first) {
                        alertsb.append(',');
                    }
                    alertsb.append('\"').append(regex.matcher(str).replaceAll("\\\"")).append('\"');
                    first = false;
                }
                alertsb.append(']');
            }
            if (this.alertLaunchImage != null) {
                if (alertsb.length() > 1) {
                    alertsb.append(',');
                }
                alertsb.append("\"launch-image\":\"").append(regex.matcher(this.alertLaunchImage).replaceAll("\\\"")).append('\"');
            }
            alertsb.append('}');
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\"aps\":{\"alert\":").append((CharSequence)alertsb);
        if (this.badge > 0) {
            sb.append(",\"badge\":").append(this.badge);
        }
        if (this.contentAvailable > 0) {
            sb.append(",\"content-available\":").append(this.contentAvailable);
        }
        if (this.sound != null) {
            sb.append(",\"sound\":\"").append(this.sound).append('\"');
        }
        sb.append("}");
        if (this.attributes.isEmpty()) {
            sb.append('}');
        } else {
            sb.append(',').append(JsonFactory.root().getConvert().convertTo(this.attributes).substring(1));
        }
        return sb.toString();
    }

    public String getAlertTitle() {
        return this.alertTitle;
    }

    public void setAlertTitle(String alertTitle) {
        this.alertTitle = alertTitle;
    }

    public String getAlertBody() {
        return this.alertBody;
    }

    public void setAlertBody(String alertBody) {
        this.alertBody = alertBody;
    }

    public String getAlertTitleLocKey() {
        return this.alertTitleLocKey;
    }

    public void setAlertTitleLocKey(String alertTitleLocKey) {
        this.alertTitleLocKey = alertTitleLocKey;
    }

    public String[] getAlertTitleLocArgs() {
        return this.alertTitleLocArgs;
    }

    public void setAlertTitleLocArgs(String[] alertTitleLocArgs) {
        this.alertTitleLocArgs = alertTitleLocArgs;
    }

    public String getAlertActionLocKey() {
        return this.alertActionLocKey;
    }

    public void setAlertActionLocKey(String alertActionLocKey) {
        this.alertActionLocKey = alertActionLocKey;
    }

    public String getAlertLocKey() {
        return this.alertLocKey;
    }

    public void setAlertLocKey(String alertLocKey) {
        this.alertLocKey = alertLocKey;
    }

    public String[] getAlertLocArgs() {
        return this.alertLocArgs;
    }

    public void setAlertLocArgs(String[] alertLocArgs) {
        this.alertLocArgs = alertLocArgs;
    }

    public String getAlertLaunchImage() {
        return this.alertLaunchImage;
    }

    public void setAlertLaunchImage(String alertLaunchImage) {
        this.alertLaunchImage = alertLaunchImage;
    }

    public int getContentAvailable() {
        return this.contentAvailable;
    }

    public void setContentAvailable(int contentAvailable) {
        this.contentAvailable = contentAvailable;
    }

    public String getAlert() {
        return this.alert;
    }

    public void setAlert(String alert) {
        this.alert = alert;
    }

    public int getBadge() {
        return this.badge;
    }

    public void setBadge(int badge) {
        this.badge = badge;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }
}

