/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.support.DomainDataRegionImpl;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.redisson.Redisson;
import org.redisson.api.RMapCache;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.config.Config;
import org.redisson.hibernate.RedissonCacheKeysFactory;
import org.redisson.hibernate.RedissonStorage;

public class RedissonRegionFactory
extends RegionFactoryTemplate {
    private static final long serialVersionUID = 3785315696581773811L;
    public static final String QUERY_DEF = "query";
    public static final String COLLECTION_DEF = "collection";
    public static final String ENTITY_DEF = "entity";
    public static final String NATURAL_ID_DEF = "naturalid";
    public static final String TIMESTAMPS_DEF = "timestamps";
    public static final String MAX_ENTRIES_SUFFIX = ".eviction.max_entries";
    public static final String TTL_SUFFIX = ".expiration.time_to_live";
    public static final String MAX_IDLE_SUFFIX = ".expiration.max_idle_time";
    public static final String CONFIG_PREFIX = "hibernate.cache.redisson.";
    public static final String REDISSON_CONFIG_PATH = "hibernate.cache.redisson.config";
    public static final String FALLBACK = "hibernate.cache.redisson.fallback";
    private RedissonClient redisson;
    private CacheKeysFactory cacheKeysFactory;
    protected boolean fallback;

    protected CacheKeysFactory getImplicitCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    protected void prepareForUse(SessionFactoryOptions settings, Map properties) throws CacheException {
        this.redisson = this.createRedissonClient(settings.getServiceRegistry(), properties);
        String fallbackValue = properties.getOrDefault(FALLBACK, "false");
        this.fallback = Boolean.valueOf(fallbackValue);
        StrategySelector selector = (StrategySelector)settings.getServiceRegistry().getService(StrategySelector.class);
        this.cacheKeysFactory = (CacheKeysFactory)selector.resolveDefaultableStrategy(CacheKeysFactory.class, properties.get("hibernate.cache.keys_factory"), (Object)new RedissonCacheKeysFactory(this.redisson.getConfig().getCodec()));
    }

    protected RedissonClient createRedissonClient(StandardServiceRegistry registry, Map properties) {
        Config config = null;
        if (!properties.containsKey(REDISSON_CONFIG_PATH)) {
            config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), "redisson.json");
            if (config == null) {
                config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), "redisson.yaml");
            }
        } else {
            String configPath = ConfigurationHelper.getString((String)REDISSON_CONFIG_PATH, (Map)properties);
            config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), configPath);
            if (config == null) {
                config = this.loadConfig(configPath);
            }
        }
        if (config == null) {
            throw new CacheException("Unable to locate Redisson configuration");
        }
        return Redisson.create((Config)config);
    }

    private Config loadConfig(String configPath) {
        try {
            return Config.fromYAML((File)new File(configPath));
        }
        catch (IOException e) {
            try {
                return Config.fromJSON((File)new File(configPath));
            }
            catch (IOException e1) {
                throw new CacheException("Can't parse default yaml config", (Throwable)e1);
            }
        }
    }

    private Config loadConfig(ClassLoader classLoader, String fileName) {
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is != null) {
            try {
                return Config.fromYAML((InputStream)is);
            }
            catch (IOException e) {
                try {
                    is = classLoader.getResourceAsStream(fileName);
                    return Config.fromJSON((InputStream)is);
                }
                catch (IOException e1) {
                    throw new CacheException("Can't parse yaml config", (Throwable)e1);
                }
            }
        }
        return null;
    }

    protected void releaseFromUse() {
        this.redisson.shutdown();
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        long time = System.currentTimeMillis() << 12;
        try {
            return (Long)this.redisson.getScript((Codec)LongCodec.INSTANCE).eval(RScript.Mode.READ_WRITE, "local currentTime = redis.call('get', KEYS[1]);if currentTime == false then redis.call('set', KEYS[1], ARGV[1]); return ARGV[1]; end;local nextValue = math.max(tonumber(ARGV[1]), tonumber(currentTime) + 1); redis.call('set', KEYS[1], nextValue); return nextValue;", RScript.ReturnType.INTEGER, Arrays.asList("redisson-hibernate-timestamp"), new Object[]{time});
        }
        catch (Exception e) {
            if (this.fallback) {
                return super.nextTimestamp();
            }
            throw e;
        }
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        this.verifyStarted();
        return new DomainDataRegionImpl(regionConfig, (RegionFactoryTemplate)this, this.createDomainDataStorageAccess(regionConfig, buildingContext), this.getImplicitCacheKeysFactory(), buildingContext);
    }

    protected DomainDataStorageAccess createDomainDataStorageAccess(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        String defaultKey = null;
        if (!regionConfig.getCollectionCaching().isEmpty()) {
            defaultKey = COLLECTION_DEF;
        } else if (!regionConfig.getEntityCaching().isEmpty()) {
            defaultKey = ENTITY_DEF;
        } else if (!regionConfig.getNaturalIdCaching().isEmpty()) {
            defaultKey = NATURAL_ID_DEF;
        } else {
            throw new IllegalArgumentException("Unable to determine entity cache type!");
        }
        RMapCache<Object, Object> mapCache = this.getCache(this.qualifyName(regionConfig.getRegionName()), buildingContext.getSessionFactory().getProperties(), defaultKey);
        return new RedissonStorage(mapCache, ((Redisson)this.redisson).getServiceManager(), buildingContext.getSessionFactory().getProperties(), defaultKey);
    }

    private String qualifyName(String name) {
        return RegionNameQualifier.INSTANCE.qualify(name, this.getOptions());
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        RMapCache<Object, Object> mapCache = this.getCache(this.qualifyName(regionName), sessionFactory.getProperties(), QUERY_DEF);
        return new RedissonStorage(mapCache, ((Redisson)this.redisson).getServiceManager(), sessionFactory.getProperties(), QUERY_DEF);
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        RMapCache<Object, Object> mapCache = this.getCache(this.qualifyName(regionName), sessionFactory.getProperties(), TIMESTAMPS_DEF);
        return new RedissonStorage(mapCache, ((Redisson)this.redisson).getServiceManager(), sessionFactory.getProperties(), TIMESTAMPS_DEF);
    }

    protected RMapCache<Object, Object> getCache(String regionName, Map properties, String defaultKey) {
        return this.redisson.getMapCache(regionName);
    }
}

