/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCache;
import org.redisson.connection.ConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonStorage
implements DomainDataStorageAccess {
    private static final Logger logger = LoggerFactory.getLogger(RedissonStorage.class);
    private final RMapCache<Object, Object> mapCache;
    private final ConnectionManager connectionManager;
    int ttl;
    int maxIdle;
    boolean fallback;
    volatile boolean fallbackMode;

    public RedissonStorage(RMapCache<Object, Object> mapCache, ConnectionManager connectionManager, Map<String, Object> properties, String defaultKey) {
        String maxIdleTime;
        String timeToLive;
        this.mapCache = mapCache;
        this.connectionManager = connectionManager;
        String maxEntries = this.getProperty(properties, mapCache.getName(), defaultKey, ".eviction.max_entries");
        if (maxEntries != null) {
            mapCache.setMaxSize(Integer.valueOf(maxEntries).intValue());
        }
        if ((timeToLive = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.time_to_live")) != null) {
            this.ttl = Integer.valueOf(timeToLive);
        }
        if ((maxIdleTime = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.max_idle_time")) != null) {
            this.maxIdle = Integer.valueOf(maxIdleTime);
        }
        String fallbackValue = (String)properties.getOrDefault("hibernate.cache.redisson.fallback", "false");
        this.fallback = Boolean.valueOf(fallbackValue);
    }

    private String getProperty(Map<String, Object> properties, String name, String defaultKey, String suffix) {
        String maxEntries = (String)properties.get("hibernate.cache.redisson." + name + suffix);
        if (maxEntries != null) {
            return maxEntries;
        }
        String defValue = (String)properties.get("hibernate.cache.redisson." + defaultKey + suffix);
        if (defValue != null) {
            return defValue;
        }
        return null;
    }

    private void ping() {
        this.fallbackMode = true;
        this.connectionManager.newTimeout(t -> {
            RFuture future = this.mapCache.isExistsAsync();
            future.onComplete((r, ex) -> {
                if (ex == null) {
                    this.fallbackMode = false;
                } else {
                    this.ping();
                }
            });
        }, 1L, TimeUnit.SECONDS);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        if (this.fallbackMode) {
            return null;
        }
        try {
            return this.mapCache.get(key);
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        if (this.fallbackMode) {
            return;
        }
        try {
            this.mapCache.fastPut(key, value, (long)this.ttl, TimeUnit.MILLISECONDS, (long)this.maxIdle, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public boolean contains(Object key) {
        if (this.fallbackMode) {
            return false;
        }
        try {
            return this.mapCache.containsKey(key);
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictData() {
        if (this.fallbackMode) {
            return;
        }
        try {
            this.mapCache.clear();
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictData(Object key) {
        if (this.fallbackMode) {
            return;
        }
        try {
            this.mapCache.fastRemove(new Object[]{key});
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void release() {
        try {
            this.mapCache.destroy();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

