/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.redisson.api.RMapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonStorage
implements DomainDataStorageAccess {
    private static final Logger logger = LoggerFactory.getLogger(RedissonStorage.class);
    private final RMapCache<Object, Object> mapCache;
    int ttl;
    int maxIdle;
    boolean fallback;

    public RedissonStorage(RMapCache<Object, Object> mapCache, Map<String, Object> properties, String defaultKey) {
        String maxIdleTime;
        String timeToLive;
        this.mapCache = mapCache;
        String maxEntries = this.getProperty(properties, mapCache.getName(), defaultKey, ".eviction.max_entries");
        if (maxEntries != null) {
            mapCache.setMaxSize(Integer.valueOf(maxEntries).intValue());
        }
        if ((timeToLive = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.time_to_live")) != null) {
            this.ttl = Integer.valueOf(timeToLive);
        }
        if ((maxIdleTime = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.max_idle_time")) != null) {
            this.maxIdle = Integer.valueOf(maxIdleTime);
        }
        String fallbackValue = (String)properties.getOrDefault("hibernate.cache.redisson.fallback", "false");
        this.fallback = Boolean.valueOf(fallbackValue);
    }

    private String getProperty(Map<String, Object> properties, String name, String defaultKey, String suffix) {
        String maxEntries = (String)properties.get("hibernate.cache.redisson." + name + suffix);
        if (maxEntries != null) {
            return maxEntries;
        }
        String defValue = (String)properties.get("hibernate.cache.redisson." + defaultKey + suffix);
        if (defValue != null) {
            return defValue;
        }
        return null;
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        try {
            return this.mapCache.get(key);
        }
        catch (Exception e) {
            if (this.fallback) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        try {
            this.mapCache.fastPut(key, value, (long)this.ttl, TimeUnit.MILLISECONDS, (long)this.maxIdle, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (this.fallback) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public boolean contains(Object key) {
        try {
            return this.mapCache.containsKey(key);
        }
        catch (Exception e) {
            if (this.fallback) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictData() {
        try {
            this.mapCache.clear();
        }
        catch (Exception e) {
            if (this.fallback) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictData(Object key) {
        try {
            this.mapCache.fastRemove(new Object[]{key});
        }
        catch (Exception e) {
            if (this.fallback) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void release() {
        try {
            this.mapCache.destroy();
        }
        catch (Exception e) {
            if (this.fallback) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }
}

