/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.cache.CacheException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.redisson.api.RedissonClient;
import org.redisson.hibernate.RedissonRegionFactory;

public class JndiRedissonRegionFactory
extends RedissonRegionFactory {
    private static final long serialVersionUID = -4814502675083325567L;
    public static final String JNDI_NAME = "hibernate.cache.redisson.jndi_name";

    @Override
    protected RedissonClient createRedissonClient(Map properties) {
        String jndiName = ConfigurationHelper.getString((String)JNDI_NAME, (Map)properties);
        if (jndiName == null) {
            throw new CacheException("hibernate.cache.redisson.jndi_name property not set");
        }
        Properties jndiProperties = JndiHelper.extractJndiProperties((Map)properties);
        InitialContext context = null;
        try {
            context = new InitialContext(jndiProperties);
            RedissonClient redissonClient = (RedissonClient)context.lookup(jndiName);
            return redissonClient;
        }
        catch (NamingException e) {
            throw new CacheException("Unable to locate Redisson instance by name: " + jndiName, (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new CacheException("Unable to close JNDI context", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void releaseFromUse() {
    }
}

