/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.support.DomainDataRegionImpl;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.redisson.Redisson;
import org.redisson.api.RMapCache;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.config.Config;
import org.redisson.hibernate.RedissonStorage;

public class RedissonRegionFactory
extends RegionFactoryTemplate {
    private static final long serialVersionUID = 3785315696581773811L;
    public static final String QUERY_DEF = "query";
    public static final String COLLECTION_DEF = "collection";
    public static final String ENTITY_DEF = "entity";
    public static final String NATURAL_ID_DEF = "naturalid";
    public static final String TIMESTAMPS_DEF = "timestamps";
    public static final String MAX_ENTRIES_SUFFIX = ".eviction.max_entries";
    public static final String TTL_SUFFIX = ".expiration.time_to_live";
    public static final String MAX_IDLE_SUFFIX = ".expiration.max_idle_time";
    public static final String CONFIG_PREFIX = "hibernate.cache.redisson.";
    public static final String REDISSON_CONFIG_PATH = "hibernate.cache.redisson.config";
    private RedissonClient redisson;

    protected void prepareForUse(SessionFactoryOptions settings, Map properties) throws CacheException {
        this.redisson = this.createRedissonClient(properties);
    }

    protected RedissonClient createRedissonClient(Map properties) {
        Config config = null;
        if (!properties.containsKey(REDISSON_CONFIG_PATH)) {
            config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), "redisson.json");
            if (config == null) {
                config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), "redisson.yaml");
            }
        } else {
            String configPath = ConfigurationHelper.getString((String)REDISSON_CONFIG_PATH, (Map)properties);
            config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), configPath);
            if (config == null) {
                config = this.loadConfig(configPath);
            }
        }
        if (config == null) {
            throw new CacheException("Unable to locate Redisson configuration");
        }
        return Redisson.create((Config)config);
    }

    private Config loadConfig(String configPath) {
        try {
            return Config.fromJSON((File)new File(configPath));
        }
        catch (IOException e) {
            try {
                return Config.fromYAML((File)new File(configPath));
            }
            catch (IOException e1) {
                throw new CacheException("Can't parse default yaml config", (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Config loadConfig(ClassLoader classLoader, String fileName) {
        Config config;
        block12: {
            InputStream is;
            block11: {
                config = null;
                try {
                    is = classLoader.getResourceAsStream(fileName);
                    if (is == null) break block11;
                    try {
                        config = Config.fromJSON((InputStream)is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new CacheException("Can't parse json config", (Throwable)e);
                }
            }
            if (config == null) {
                try {
                    is = classLoader.getResourceAsStream(fileName);
                    if (is == null) break block12;
                    try {
                        config = Config.fromYAML((InputStream)is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new CacheException("Can't parse yaml config", (Throwable)e);
                }
            }
        }
        return config;
    }

    protected void releaseFromUse() {
        this.redisson.shutdown();
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        long time = System.currentTimeMillis() << 12;
        return (Long)this.redisson.getScript((Codec)LongCodec.INSTANCE).eval(RScript.Mode.READ_WRITE, "local currentTime = redis.call('get', KEYS[1]);if currentTime == false then redis.call('set', KEYS[1], ARGV[1]); return ARGV[1]; end;local nextValue = math.max(tonumber(ARGV[1]), tonumber(currentTime) + 1); redis.call('set', KEYS[1], nextValue); return nextValue;", RScript.ReturnType.INTEGER, Arrays.asList("redisson-hibernate-timestamp"), new Object[]{time});
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        this.verifyStarted();
        return new DomainDataRegionImpl(regionConfig, (RegionFactoryTemplate)this, this.createDomainDataStorageAccess(regionConfig, buildingContext), this.getImplicitCacheKeysFactory(), buildingContext);
    }

    protected DomainDataStorageAccess createDomainDataStorageAccess(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        String defaultKey = null;
        if (!regionConfig.getCollectionCaching().isEmpty()) {
            defaultKey = COLLECTION_DEF;
        } else if (!regionConfig.getEntityCaching().isEmpty()) {
            defaultKey = ENTITY_DEF;
        } else if (!regionConfig.getNaturalIdCaching().isEmpty()) {
            defaultKey = NATURAL_ID_DEF;
        } else {
            throw new IllegalArgumentException("Unable to determine entity cache type!");
        }
        RMapCache<Object, Object> mapCache = this.getCache(regionConfig.getRegionName(), buildingContext.getSessionFactory().getProperties(), defaultKey);
        return new RedissonStorage(mapCache, buildingContext.getSessionFactory().getProperties(), defaultKey);
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        RMapCache<Object, Object> mapCache = this.getCache(regionName, sessionFactory.getProperties(), QUERY_DEF);
        return new RedissonStorage(mapCache, sessionFactory.getProperties(), QUERY_DEF);
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        RMapCache<Object, Object> mapCache = this.getCache(regionName, sessionFactory.getProperties(), TIMESTAMPS_DEF);
        return new RedissonStorage(mapCache, sessionFactory.getProperties(), TIMESTAMPS_DEF);
    }

    protected RMapCache<Object, Object> getCache(String regionName, Map properties, String defaultKey) {
        return this.redisson.getMapCache(regionName);
    }
}

