/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.region;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCache;
import org.redisson.connection.ConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRegion
implements TransactionalDataRegion,
GeneralDataRegion {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final RMapCache<Object, Object> mapCache;
    final RegionFactory regionFactory;
    final CacheDataDescription metadata;
    final ConnectionManager connectionManager;
    int ttl;
    int maxIdle;
    boolean fallback;
    volatile boolean fallbackMode;

    public BaseRegion(RMapCache<Object, Object> mapCache, ConnectionManager connectionManager, RegionFactory regionFactory, CacheDataDescription metadata, Properties properties, String defaultKey) {
        String maxIdleTime;
        String timeToLive;
        this.mapCache = mapCache;
        this.regionFactory = regionFactory;
        this.metadata = metadata;
        this.connectionManager = connectionManager;
        String maxEntries = this.getProperty(properties, mapCache.getName(), defaultKey, ".eviction.max_entries");
        if (maxEntries != null) {
            mapCache.setMaxSize(Integer.valueOf(maxEntries).intValue());
        }
        if ((timeToLive = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.time_to_live")) != null) {
            this.ttl = Integer.valueOf(timeToLive);
        }
        if ((maxIdleTime = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.max_idle_time")) != null) {
            this.maxIdle = Integer.valueOf(maxIdleTime);
        }
        String fallbackValue = (String)properties.getOrDefault((Object)"hibernate.cache.redisson.fallback", "false");
        this.fallback = Boolean.valueOf(fallbackValue);
    }

    private String getProperty(Properties properties, String name, String defaultKey, String suffix) {
        String value = properties.getProperty("hibernate.cache.redisson." + name + suffix);
        if (value != null) {
            return value;
        }
        String defValue = properties.getProperty("hibernate.cache.redisson." + defaultKey + suffix);
        if (defValue != null) {
            return defValue;
        }
        return null;
    }

    private void ping() {
        this.fallbackMode = true;
        this.connectionManager.newTimeout(t -> {
            RFuture future = this.mapCache.isExistsAsync();
            future.onComplete((r, ex) -> {
                if (ex == null) {
                    this.fallbackMode = false;
                } else {
                    this.ping();
                }
            });
        }, 1L, TimeUnit.SECONDS);
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public String getName() {
        return this.mapCache.getName();
    }

    public void destroy() throws CacheException {
        try {
            this.mapCache.destroy();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean contains(Object key) {
        if (this.fallbackMode) {
            return false;
        }
        try {
            return this.mapCache.containsKey(key);
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                this.logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public long getSizeInMemory() {
        return this.mapCache.sizeInMemory();
    }

    public long getElementCountInMemory() {
        return this.mapCache.size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map<?, ?> toMap() {
        return Collections.unmodifiableMap(this.mapCache);
    }

    public long nextTimestamp() {
        return this.regionFactory.nextTimestamp();
    }

    public int getTimeout() {
        return 245760000;
    }

    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        if (this.fallbackMode) {
            return null;
        }
        try {
            return this.mapCache.get(key);
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                this.logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void put(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        if (this.fallbackMode) {
            return;
        }
        try {
            this.mapCache.fastPut(key, value, (long)this.ttl, TimeUnit.MILLISECONDS, (long)this.maxIdle, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                this.logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evict(Object key) throws CacheException {
        if (this.fallbackMode) {
            return;
        }
        try {
            this.mapCache.fastRemove(new Object[]{key});
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                this.logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictAll() throws CacheException {
        if (this.fallbackMode) {
            return;
        }
        try {
            this.mapCache.clear();
        }
        catch (Exception e) {
            if (this.fallback) {
                this.ping();
                this.logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            throw new CacheException((Throwable)e);
        }
    }
}

