/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.region;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.redisson.api.RMapCache;

public class BaseRegion
implements TransactionalDataRegion,
GeneralDataRegion {
    final RMapCache<Object, Object> mapCache;
    final RegionFactory regionFactory;
    final CacheDataDescription metadata;
    int ttl;
    int maxIdle;

    public BaseRegion(RMapCache<Object, Object> mapCache, RegionFactory regionFactory, CacheDataDescription metadata, Properties properties, String defaultKey) {
        String maxIdleTime;
        String timeToLive;
        this.mapCache = mapCache;
        this.regionFactory = regionFactory;
        this.metadata = metadata;
        String maxEntries = this.getProperty(properties, mapCache.getName(), defaultKey, ".eviction.max_entries");
        if (maxEntries != null) {
            mapCache.setMaxSize(Integer.valueOf(maxEntries).intValue());
        }
        if ((timeToLive = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.time_to_live")) != null) {
            this.ttl = Integer.valueOf(timeToLive);
        }
        if ((maxIdleTime = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.max_idle_time")) != null) {
            this.maxIdle = Integer.valueOf(maxIdleTime);
        }
    }

    private String getProperty(Properties properties, String name, String defaultKey, String suffix) {
        String value = properties.getProperty("hibernate.cache.redisson." + name + suffix);
        if (value != null) {
            return value;
        }
        String defValue = properties.getProperty("hibernate.cache.redisson." + defaultKey + suffix);
        if (defValue != null) {
            return defValue;
        }
        return null;
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public String getName() {
        return this.mapCache.getName();
    }

    public void destroy() throws CacheException {
        try {
            this.mapCache.destroy();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean contains(Object key) {
        try {
            return this.mapCache.containsKey(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public long getSizeInMemory() {
        return this.mapCache.sizeInMemory();
    }

    public long getElementCountInMemory() {
        return this.mapCache.size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map<?, ?> toMap() {
        return Collections.unmodifiableMap(this.mapCache);
    }

    public long nextTimestamp() {
        return this.regionFactory.nextTimestamp();
    }

    public int getTimeout() {
        return 245760000;
    }

    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        try {
            return this.mapCache.get(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        try {
            this.mapCache.fastPut(key, value, (long)this.ttl, TimeUnit.MILLISECONDS, (long)this.maxIdle, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void evict(Object key) throws CacheException {
        try {
            this.mapCache.fastRemove(new Object[]{key});
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void evictAll() throws CacheException {
        try {
            this.mapCache.clear();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

