/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.hibernate.strategy.AbstractReadWriteAccessStrategy;

public class ReadWriteNaturalIdRegionAccessStrategy
extends AbstractReadWriteAccessStrategy
implements NaturalIdRegionAccessStrategy {
    public ReadWriteNaturalIdRegionAccessStrategy(Settings settings, GeneralDataRegion region, RMapCache<Object, Object> mapCache) {
        super(settings, region, mapCache);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        RLock writeLock = this.mapCache.getReadWriteLock(key).writeLock();
        writeLock.lock();
        try {
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(session, key);
            if (item == null) {
                this.region.put(session, key, (Object)new AbstractReadWriteAccessStrategy.Item(value, null, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        RLock writeLock = this.mapCache.getReadWriteLock(key).writeLock();
        writeLock.lock();
        try {
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(session, key);
            if (item != null && item.isUnlockable(lock)) {
                AbstractReadWriteAccessStrategy.Lock lockItem = (AbstractReadWriteAccessStrategy.Lock)item;
                if (lockItem.wasLockedConcurrently()) {
                    this.decrementLock(session, key, lockItem);
                    boolean bl = false;
                    return bl;
                }
                this.region.put(session, key, (Object)new AbstractReadWriteAccessStrategy.Item(value, null, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(session, key, item);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return DefaultCacheKeysFactory.staticCreateNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SharedSessionContractImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetNaturalIdValues((Object)cacheKey);
    }
}

