/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.region;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.redisson.api.RMapCache;
import org.redisson.hibernate.region.BaseRegion;
import org.redisson.hibernate.strategy.NonStrictReadWriteNaturalIdRegionAccessStrategy;
import org.redisson.hibernate.strategy.ReadOnlyNaturalIdRegionAccessStrategy;
import org.redisson.hibernate.strategy.ReadWriteNaturalIdRegionAccessStrategy;
import org.redisson.hibernate.strategy.TransactionalNaturalIdRegionAccessStrategy;

public class RedissonNaturalIdRegion
extends BaseRegion
implements NaturalIdRegion {
    private final Settings settings;

    public RedissonNaturalIdRegion(RMapCache<Object, Object> mapCache, RegionFactory regionFactory, CacheDataDescription metadata, Settings settings, Properties properties, String defaultKey) {
        super(mapCache, regionFactory, metadata, properties, defaultKey);
        this.settings = settings;
    }

    public NaturalIdRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (accessType == AccessType.READ_ONLY) {
            return new ReadOnlyNaturalIdRegionAccessStrategy(this.settings, this);
        }
        if (accessType == AccessType.READ_WRITE) {
            return new ReadWriteNaturalIdRegionAccessStrategy(this.settings, this, (RMapCache<Object, Object>)this.mapCache);
        }
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            return new NonStrictReadWriteNaturalIdRegionAccessStrategy(this.settings, this);
        }
        if (accessType == AccessType.TRANSACTIONAL) {
            return new TransactionalNaturalIdRegionAccessStrategy(this.settings, this);
        }
        throw new CacheException("Unsupported access strategy: " + accessType);
    }
}

