/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import java.io.Serializable;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionImplementor;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.hibernate.strategy.BaseRegionAccessStrategy;

public class AbstractReadWriteAccessStrategy
extends BaseRegionAccessStrategy {
    private final UUID uuid = UUID.randomUUID();
    private final AtomicLong nextLockId = new AtomicLong();
    final RMapCache<Object, Object> mapCache;

    public AbstractReadWriteAccessStrategy(Settings settings, GeneralDataRegion region, RMapCache<Object, Object> mapCache) {
        super(settings, region);
        this.mapCache = mapCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        RLock readLock = this.mapCache.getReadWriteLock(key).readLock();
        readLock.lock();
        try {
            Lockable item = (Lockable)this.region.get(session, key);
            if (item != null && item.isReadable(txTimestamp)) {
                Object object = item.getValue();
                return object;
            }
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        RLock writeLock = this.mapCache.getReadWriteLock(key).writeLock();
        writeLock.lock();
        try {
            boolean writeable;
            Lockable item = (Lockable)this.region.get(session, key);
            Comparator comparator = ((TransactionalDataRegion)this.region).getCacheDataDescription().getVersionComparator();
            boolean bl = writeable = item == null || item.isWriteable(txTimestamp, version, comparator);
            if (writeable) {
                this.region.put(session, key, (Object)new Item(value, version, this.region.nextTimestamp()));
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        RLock writeLock = this.mapCache.getReadWriteLock(key).writeLock();
        writeLock.lock();
        try {
            Lockable item = (Lockable)this.region.get(session, key);
            long timeout = this.region.nextTimestamp() + (long)this.region.getTimeout();
            Lock lock = item == null ? new Lock(timeout, this.uuid, this.nextLockId.getAndIncrement(), version) : item.lock(timeout, this.uuid, this.nextLockId.getAndIncrement());
            this.region.put(session, key, (Object)lock);
            Lock lock2 = lock;
            return lock2;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        RLock writeLock = this.mapCache.getReadWriteLock(key).writeLock();
        writeLock.lock();
        try {
            Lockable item = (Lockable)this.region.get(session, key);
            if (item != null && item.isUnlockable(lock)) {
                this.decrementLock(session, key, (Lock)item);
            } else {
                this.handleLockExpiry(session, key, item);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void decrementLock(SessionImplementor session, Object key, Lock lock) {
        lock.unlock(this.region.nextTimestamp());
        this.region.put(session, key, (Object)lock);
    }

    protected void handleLockExpiry(SessionImplementor session, Object key, Lockable lock) {
        long ts = this.region.nextTimestamp() + (long)this.region.getTimeout();
        Lock newLock = new Lock(ts, this.uuid, this.nextLockId.getAndIncrement(), null);
        newLock.unlock(ts);
        this.region.put(session, key, (Object)newLock);
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    SoftLock {
        private static final long serialVersionUID = 2L;
        private UUID sourceUuid;
        private long lockId;
        private Object version;
        private long timeout;
        private boolean concurrent;
        private int multiplicity = 1;
        private long unlockTimestamp;

        public Lock(long timeout, UUID sourceUuid, long lockId, Object version) {
            this.timeout = timeout;
            this.lockId = lockId;
            this.version = version;
            this.sourceUuid = sourceUuid;
        }

        @Override
        public boolean isReadable(long txTimestamp) {
            return false;
        }

        public boolean isWriteable(long txTimestamp, Object newVersion, Comparator versionComparator) {
            if (txTimestamp > this.timeout) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? txTimestamp > this.unlockTimestamp : versionComparator.compare(this.version, newVersion) < 0;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public boolean isUnlockable(SoftLock lock) {
            return this.equals(lock);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Lock) {
                return this.lockId == ((Lock)o).lockId && this.sourceUuid.equals(((Lock)o).sourceUuid);
            }
            return false;
        }

        public int hashCode() {
            int hash = this.sourceUuid != null ? this.sourceUuid.hashCode() : 0;
            int temp = (int)this.lockId;
            for (int i = 1; i < 2; ++i) {
                temp = (int)((long)temp ^ this.lockId >>> i * 32);
            }
            return hash + temp;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrent;
        }

        @Override
        public Lock lock(long timeout, UUID uuid, long lockId) {
            this.concurrent = true;
            ++this.multiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long timestamp) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = timestamp;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Lock Source-UUID:" + this.sourceUuid + " Lock-ID:" + this.lockId);
            return sb.toString();
        }
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private static final long serialVersionUID = 1L;
        private Object value;
        private Object version;
        private long timestamp;

        public Item(Object value, Object version, long timestamp) {
            this.value = value;
            this.version = version;
            this.timestamp = timestamp;
        }

        @Override
        public boolean isReadable(long txTimestamp) {
            return txTimestamp > this.timestamp;
        }

        @Override
        public boolean isWriteable(long txTimestamp, Object newVersion, Comparator<Object> versionComparator) {
            return this.version != null && versionComparator.compare(this.version, newVersion) < 0;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isUnlockable(SoftLock lock) {
            return false;
        }

        @Override
        public Lock lock(long timeout, UUID uuid, long lockId) {
            return new Lock(timeout, uuid, lockId, this.version);
        }
    }

    public static interface Lockable {
        public boolean isReadable(long var1);

        public boolean isWriteable(long var1, Object var3, Comparator<Object> var4);

        public Object getValue();

        public boolean isUnlockable(SoftLock var1);

        public Lock lock(long var1, UUID var3, long var4);
    }
}

