/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.Measurement;
import org.redfx.strange.gate.Oracle;
import org.redfx.strangefx.simulator.RenderModel;
import org.redfx.strangefx.ui.GateSymbol;
import org.redfx.strangefx.ui.MeasurementUI;
import org.redfx.strangefx.ui.ProbabilitiesGate;

public class QubitFlow
extends Region {
    private final int STEP_WIDTH = 44;
    private boolean askOnTop = false;
    private static final GateSymbol SPACER = new GateSymbol((Gate)new Identity(0), false){
        {
            this.getStyleClass().setAll((Object[])new String[]{"gate-spacer"});
            int SPACER_WIDTH = 5;
            this.setMaxWidth(SPACER_WIDTH);
            this.setMinWidth(SPACER_WIDTH);
            this.setText(null);
        }
    };
    private Label title = new Label();
    private MeasurementUI measurement = new MeasurementUI();
    private List<MeasurementUI> intermediates = new ArrayList<MeasurementUI>();
    private Pane gateRow = new Pane();
    private HBox allGates = new HBox();
    private final int idx;
    private Region oldParent = null;
    private final ArrayList<Gate> gateList = new ArrayList();
    private final RenderModel model;
    private InvalidationListener endStateListener;

    public QubitFlow(int index, RenderModel model) {
        this.model = model;
        this.idx = index;
        this.fillGatesFromModel(model);
        this.title.setText(String.format("q[%d] I0>", this.idx));
        this.gateRow.getChildren().add((Object)SPACER);
        this.getStyleClass().add((Object)"qubit");
        this.gateRow.getStyleClass().add((Object)"gate-row");
        this.title.getStyleClass().add((Object)"title");
        this.title.setPrefWidth(85.0);
        BorderPane base = new BorderPane();
        base.getStyleClass().add((Object)"base");
        base.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        base.setLeft((Node)this.title);
        base.setCenter((Node)this.allGates);
        this.allGates.getChildren().addAll((Object[])new Node[]{this.gateRow});
        HBox.setHgrow((Node)this.gateRow, (Priority)Priority.ALWAYS);
        base.setRight((Node)this.measurement);
        BorderPane.setAlignment((Node)this.title, (Pos)Pos.CENTER);
        BorderPane.setAlignment((Node)this.measurement, (Pos)Pos.CENTER);
        StackPane stack = new StackPane(new Node[]{base});
        this.sceneProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (QubitFlow.this.getScene() != null) {
                    QubitFlow.this.prefWidthProperty().bind((ObservableValue)QubitFlow.this.getScene().widthProperty());
                }
            }
        });
        stack.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        stack.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)stack);
        this.setOnDragOver(event -> {
            if (event.getGestureSource() != this && event.getDragboard().getContent(GateSymbol.DRAGGABLE_GATE) != null) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                int intidx = this.getInternalIndex(event.getX());
                this.removeSpacer();
                SPACER.setTranslateX(intidx * 44);
                this.gateRow.getChildren().add((Object)SPACER);
            }
            event.consume();
        });
        this.setOnDragDropped(e -> {
            double xzero = this.allGates.getLayoutX();
            double xtrans = e.getX() - xzero;
            Dragboard db = e.getDragboard();
            if (db.hasContent(GateSymbol.DRAGGABLE_GATE)) {
                int spacerIndex = this.getInternalIndex(e.getX());
                GateSymbol symbol = (GateSymbol)((Object)((Object)System.getProperties().get(GateSymbol.DRAGGABLE_GATE)));
                GridPane.setMargin((Node)symbol, (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
                this.removeSpacer();
                if (TransferMode.MOVE == e.getTransferMode()) {
                    symbol.removeFromParent();
                    symbol.setTranslateX(spacerIndex * 44);
                    this.insert(symbol, spacerIndex);
                    this.gateRow.getChildren().add((Object)symbol);
                    e.setDropCompleted(true);
                } else {
                    symbol = symbol.getGate() == null ? GateSymbol.of(GateSymbol.ControlQubit.OFF) : GateSymbol.of(symbol.getGate().getClass(), this.idx);
                    symbol.setTranslateX(spacerIndex * 44);
                    this.gateRow.getChildren().add((Object)symbol);
                    this.insert(symbol, spacerIndex);
                    e.setDropCompleted(true);
                }
            }
            this.redraw();
            this.updateModel();
            e.consume();
        });
        this.gateRow.setOnDragExited(e -> this.removeSpacer());
        this.endStateListener = this.createEndStateListener();
        model.getEndStates().addListener(this.endStateListener);
        this.redraw();
    }

    private InvalidationListener createEndStateListener() {
        InvalidationListener answer = o -> {
            if (this.model != null && this.model.getEndStates().size() > this.idx) {
                double mv = (Double)this.model.getEndStates().get(this.idx);
                this.measurement.setMeasuredChance(mv);
            }
        };
        return answer;
    }

    public void cleanup() {
        this.model.getEndStates().removeListener(this.endStateListener);
    }

    private void removeSpacer() {
        this.gateRow.getChildren().remove((Object)SPACER);
    }

    public boolean wantsOnTop() {
        return this.askOnTop;
    }

    public GateSymbol addGate(Gate gate) {
        int spacerIndex;
        if (this.gateRow.getChildren().isEmpty()) {
            this.gateRow.getChildren().add((Object)SPACER);
        }
        GateSymbol symbol = GateSymbol.of(gate);
        if (gate instanceof Oracle) {
            this.askOnTop = true;
        }
        if ((spacerIndex = this.gateRow.getChildren().indexOf((Object)SPACER)) < 0) {
            this.gateRow.getChildren().add((Object)symbol);
        } else {
            this.gateRow.getChildren().set(spacerIndex, (Object)symbol);
        }
        this.redraw();
        return symbol;
    }

    public GateSymbol addAdditonalGateSymbol(Gate gate, int gateidx) {
        if (this.gateRow.getChildren().isEmpty()) {
            this.gateRow.getChildren().add((Object)SPACER);
        }
        GateSymbol symbol = GateSymbol.of(gate, gateidx);
        int spacerIndex = this.gateRow.getChildren().indexOf((Object)SPACER);
        if (spacerIndex < 0) {
            this.gateRow.getChildren().add((Object)symbol);
        } else {
            this.gateRow.getChildren().set(spacerIndex, (Object)symbol);
        }
        return symbol;
    }

    public Pane getGateRow() {
        return this.gateRow;
    }

    private double getOccupiedWidth() {
        double width = 0.0;
        int cnt = 0;
        for (Node node : this.gateRow.getChildren()) {
            GateSymbol gs = (GateSymbol)node;
            if (gs.isIdentity()) continue;
            width += ((GateSymbol)node).getWidth();
            ++cnt;
        }
        return width + (double)(44 * cnt);
    }

    private int getInternalIndex(double x) {
        double dist = x - this.allGates.getLayoutX();
        double div = dist / 44.0;
        return (int)div;
    }

    public int getIndex() {
        return this.idx;
    }

    public void clear() {
        this.model.getEndStates().removeListener(this.endStateListener);
        this.gateRow.getChildren().clear();
    }

    public MeasurementUI getOutput() {
        return this.measurement;
    }

    private void insert(GateSymbol gs, int locationIndex) {
        Gate g = gs.getGate();
        g.setMainQubitIndex(this.idx);
        while (this.gateList.size() < locationIndex) {
            this.gateList.add(this.gateList.size(), (Gate)new Identity(this.idx));
        }
        if (this.gateList.size() == locationIndex) {
            this.gateList.add(this.gateList.size(), g);
            return;
        }
        if (this.gateList.get(locationIndex) instanceof Identity) {
            this.gateList.set(locationIndex, g);
            return;
        }
        this.gateList.add(locationIndex, g);
    }

    public void redraw() {
        this.gateRow.getChildren().clear();
        this.intermediates.clear();
        Map<Integer, Qubit> intermediateValues = this.model.getIntermediateStatesByQubit(this.idx);
        double deltax = 0.0;
        int iv = 0;
        for (Gate gate : this.gateList) {
            if (gate != null) {
                Object symbol = null;
                if (gate instanceof Measurement) {
                    symbol = this.createMeasurementLine(gate);
                } else if (gate instanceof ProbabilitiesGate) {
                    ProbabilitiesGate pg = (ProbabilitiesGate)gate;
                    symbol = pg.createUI();
                } else {
                    GateSymbol gs = GateSymbol.of(gate);
                    gs.setWire(this);
                    symbol = gs;
                }
                symbol.setTranslateX(deltax);
                symbol.translateYProperty().bind((ObservableValue)this.gateRow.heightProperty().add(-40).divide(2));
                this.gateRow.getChildren().add(symbol);
                BorderPane.setAlignment((Node)symbol, (Pos)Pos.CENTER);
            }
            ++iv;
            deltax += 44.0;
        }
    }

    public void gateSymbolRemoved(GateSymbol symbol) {
        Optional<Gate> target = this.gateList.stream().filter(g -> g.equals(symbol.getGate())).findFirst();
        if (target.isPresent()) {
            int stepidx = this.gateList.indexOf(target.get());
            this.gateList.remove(stepidx);
            this.gateList.add(stepidx, (Gate)new Identity(this.idx));
        } else {
            System.err.println("Didn't find gate");
        }
        this.updateModel();
    }

    private void updateModel() {
        this.model.updateGatesForQubit(this.idx, this.gateList);
        this.model.refreshRequest().set(true);
    }

    private Gate createGate(Gate g) {
        return g;
    }

    private void fillGatesFromModel(RenderModel model) {
        this.gateList.clear();
        for (Step s : model.getSteps()) {
            if (s.getType() == Step.Type.PSEUDO) {
                this.gateList.add((Gate)new Measurement(this.idx));
                continue;
            }
            if (s.getType() == Step.Type.PROBABILITY) {
                if (this.idx == 0) {
                    this.gateList.add(new ProbabilitiesGate(s));
                    continue;
                }
                this.gateList.add((Gate)new Identity(this.idx));
                continue;
            }
            Optional<Gate> hasGate = s.getGates().stream().filter(g -> g.getMainQubitIndex() == this.idx).findFirst();
            if (hasGate.isPresent()) {
                this.gateList.add(hasGate.get());
                continue;
            }
            this.gateList.add((Gate)new Identity(this.idx));
        }
    }

    private Region createMeasurementLine(Gate gate) {
        GateSymbol gs = GateSymbol.of(gate);
        gs.setWire(this);
        Line l = new Line(22.0, 30.0, 100.0, 30.0);
        l.getStyleClass().add((Object)"wire");
        l.endXProperty().bind((ObservableValue)this.widthProperty());
        Pane canvas = new Pane();
        canvas.getChildren().addAll((Object[])new Node[]{l, gs});
        return canvas;
    }

    private Group createProbability(Step s) {
        Program program = s.getProgram();
        Result result = program.getResult();
        Complex[] ip = result.getIntermediateProbability(s.getIndex());
        int nq = program.getNumberQubits();
        int N = 1 << nq;
        double deltaY = (66.0 * (double)nq - 10.0 + 38.0) / (double)N;
        Group answer = new Group();
        Rectangle rect2 = new Rectangle(0.0, 0.0, 40.0, (double)(66 * nq - 10 + 38));
        rect2.setFill((Paint)Color.WHITE);
        rect2.setStroke((Paint)Color.BLUE);
        rect2.setStrokeWidth(1.0);
        answer.getChildren().add((Object)rect2);
        for (int i = 0; i < N; ++i) {
            double startY = (double)i * deltaY;
            Rectangle minibar = new Rectangle(1.0, (double)i * deltaY, 38.0 * ip[i].abssqr(), deltaY - 1.0);
            minibar.setFill((Paint)Color.GREEN);
            Line l = new Line(1.0, startY, 39.0, startY);
            l.setFill((Paint)Color.LIGHTGRAY);
            l.setStrokeWidth(1.0);
            answer.getChildren().add((Object)l);
            answer.getChildren().add((Object)minibar);
        }
        return answer;
    }
}

