/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.ui;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Gate;
import org.redfx.strange.gate.Cnot;
import org.redfx.strange.gate.Cz;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.Oracle;
import org.redfx.strange.gate.Toffoli;
import org.redfx.strangefx.ui.ProbabilitiesGate;
import org.redfx.strangefx.ui.QubitFlow;

public class GateSymbol
extends Label {
    static final DataFormat DRAGGABLE_GATE = new DataFormat(new String[]{"draggable-gate"});
    public static final int HEIGHT = 40;
    public static final int WIDTH = 40;
    public static final int SEP = 77;
    private final Gate gate;
    private final boolean movable;
    public int spanWires = 1;
    public boolean probability = false;
    private QubitFlow wire;
    private int index;
    static double LINE_WIDTH = 2.0;

    public static GateSymbol of(Class<? extends Gate> clazz, int idx) {
        return GateSymbol.of(clazz, idx, true);
    }

    public static GateSymbol of(Class<? extends Gate> clazz, int idx, Boolean movable) {
        GateSymbol answer = null;
        try {
            answer = new GateSymbol(clazz.getDeclaredConstructor(Integer.TYPE).newInstance(idx), movable, 0);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't create gatesymbol for class " + clazz, ex);
        }
        return answer;
    }

    public static GateSymbol of(Gate gate, Boolean movable) {
        return new GateSymbol(gate, movable, 0);
    }

    public static GateSymbol of(Gate gate) {
        return new GateSymbol(gate, true, 0);
    }

    public static GateSymbol of(Gate gate, int idx) {
        return new GateSymbol(gate, true, idx);
    }

    public static GateSymbol of(ControlQubit ctrl) {
        return new GateSymbol(ctrl);
    }

    GateSymbol(Gate gate, boolean movable) {
        this(gate, movable, 0);
    }

    GateSymbol(Gate gate, boolean movable, int idx) {
        this.index = idx;
        this.spanWires = gate.getAffectedQubitIndexes().size();
        this.gate = Objects.requireNonNull(gate);
        this.movable = movable;
        if (!(gate instanceof Identity)) {
            if (gate instanceof BlockGate) {
                this.setGraphic((Node)this.createBlockNode((BlockGate)gate));
            } else if (gate instanceof Cnot) {
                this.setGraphic((Node)this.createCNotNode((Cnot)gate));
            } else if (gate instanceof Toffoli) {
                this.setGraphic((Node)this.createToffoliNode((Toffoli)gate));
            } else if (idx == 0 && gate instanceof Cz) {
                this.setGraphic((Node)this.createCZNode((Cz)gate));
            } else {
                this.getStyleClass().setAll((Object[])new String[]{"gate-symbol", this.getStyle(gate.getGroup())});
                this.setText(gate.getCaption());
            }
        }
        this.setMinWidth(40.0);
        this.setMinHeight(40.0);
        this.setAlignment(Pos.CENTER);
        if (gate instanceof Oracle) {
            Oracle oracle = (Oracle)gate;
            this.spanWires = oracle.getQubits();
            this.setOpacity(0.9);
        }
        if (gate instanceof ProbabilitiesGate) {
            this.probability = true;
        }
        if (movable) {
            this.setContextMenu(this.buildContextMenu());
        }
        this.prepareDrag();
    }

    void prepareDrag() {
        this.setOnDragDetected(e -> {
            System.getProperties().put(DRAGGABLE_GATE, (Object)this);
            Dragboard db = this.startDragAndDrop(TransferMode.ANY);
            db.setDragView((Image)this.snapshot(null, null));
            ClipboardContent content = new ClipboardContent();
            content.putString(this.getName());
            content.put((Object)DRAGGABLE_GATE, (Object)"");
            db.setContent((Map)content);
            e.consume();
        });
        this.setOnDragDone(e -> System.getProperties().remove(DRAGGABLE_GATE));
        this.setOnDragDropped(e -> {});
    }

    GateSymbol(ControlQubit ctrl) {
        this.gate = null;
        this.movable = false;
        this.setDot();
        this.prepareDrag();
    }

    public void setWire(QubitFlow f) {
        this.wire = f;
    }

    public String getName() {
        return this.gate == null ? "NOT" : this.gate.getName();
    }

    public boolean isIdentity() {
        return this.gate instanceof Identity;
    }

    private String getStyle(String group) {
        return group.toLowerCase().replaceAll("_", "");
    }

    public Gate getGate() {
        return this.gate;
    }

    public boolean isMovable() {
        return this.movable;
    }

    private ContextMenu buildContextMenu() {
        ContextMenu menu = new ContextMenu();
        MenuItem mnRemove = new MenuItem("Remove");
        menu.setOnAction(e -> this.removeFromParent());
        menu.getItems().addAll((Object[])new MenuItem[]{mnRemove});
        return menu;
    }

    public void removeFromParent() {
        Pane parent = (Pane)this.getParent();
        if (parent != null) {
            parent.getChildren().remove((Object)this);
        }
        if (this.wire != null) {
            this.wire.gateSymbolRemoved(this);
        }
    }

    private Parent createBlockNode(BlockGate gate) {
        AnchorPane answer = new AnchorPane();
        Label l = new Label(gate.getCaption());
        l.setTranslateX(2.0);
        l.setTranslateY(2.0);
        l.getStyleClass().setAll((Object[])new String[]{"gate-block-text"});
        List qidxs = gate.getAffectedQubitIndexes();
        int mqi = gate.getMainQubitIndex();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        Iterator iterator = qidxs.iterator();
        while (iterator.hasNext()) {
            int qidx = (Integer)iterator.next();
            if (qidx > max) {
                max = qidx;
            }
            if (qidx >= min) continue;
            min = qidx;
        }
        int span = max - min + 1;
        Rectangle rect = new Rectangle(0.0, 0.0, 40.0, (double)(40 + (span - 1) * 77));
        rect.setFill((Paint)Color.LIGHTGREEN);
        if (min < mqi) {
            rect.setLayoutY((double)(77 * (min - mqi)));
        }
        answer.getChildren().add((Object)rect);
        answer.getChildren().add((Object)l);
        return answer;
    }

    private Parent createCNotNode(Cnot cnot) {
        double div2 = 20.0;
        int midx = cnot.getMainQubitIndex();
        int sidx = cnot.getSecondQubitIndex();
        AnchorPane answer = new AnchorPane();
        Circle con = new Circle(0.0, 0.0, 5.0, (Paint)Color.DARKGREY);
        con.setTranslateY(-5.0);
        Circle c = new Circle(0.0, 0.0, 10.0, (Paint)Color.TRANSPARENT);
        c.setTranslateY(-10.0);
        c.setLayoutY((double)(77 * (sidx - midx)));
        c.setStroke((Paint)Color.DARKGRAY);
        c.setStrokeWidth(2.0);
        Line l = new Line(0.0, 0.0, 0.0, (double)(77 * (sidx - midx) + 10));
        l.setStrokeWidth(LINE_WIDTH);
        l.setStroke((Paint)Color.DARKGRAY);
        AnchorPane.setTopAnchor((Node)con, (Double)20.0);
        AnchorPane.setTopAnchor((Node)l, (Double)20.0);
        AnchorPane.setTopAnchor((Node)c, (Double)Double.valueOf(77 * (sidx - midx) + 20));
        AnchorPane.setLeftAnchor((Node)con, (Double)(div2 - 5.0));
        AnchorPane.setLeftAnchor((Node)l, (Double)(div2 - LINE_WIDTH / 2.0));
        AnchorPane.setLeftAnchor((Node)c, (Double)(div2 - 10.0));
        answer.getChildren().addAll((Object[])new Node[]{con, c, l});
        answer.setPrefWidth(40.0);
        return answer;
    }

    private Parent createCZNode(Cz cnot) {
        double div2 = 20.0;
        int midx = cnot.getMainQubitIndex();
        int sidx = cnot.getSecondQubitIndex();
        AnchorPane answer = new AnchorPane();
        Circle con = new Circle(0.0, 0.0, 5.0, (Paint)Color.DARKGREY);
        con.setTranslateY(-5.0);
        Label z = new Label("Z");
        z.getStyleClass().setAll((Object[])new String[]{"gate-symbol", this.getStyle(this.gate.getGroup())});
        z.setTranslateY(-20.0);
        z.setLayoutY((double)(77 * (sidx - midx)));
        z.setMinWidth(40.0);
        z.setMinHeight(40.0);
        z.setAlignment(Pos.CENTER);
        Line l = new Line(0.0, 0.0, 0.0, (double)(77 * (sidx - midx) - 20));
        l.setStrokeWidth(LINE_WIDTH);
        l.setStroke((Paint)Color.DARKGRAY);
        AnchorPane.setTopAnchor((Node)con, (Double)20.0);
        AnchorPane.setTopAnchor((Node)l, (Double)20.0);
        AnchorPane.setTopAnchor((Node)z, (Double)Double.valueOf(77 * (sidx - midx) + 20));
        AnchorPane.setLeftAnchor((Node)con, (Double)(div2 - 5.0));
        AnchorPane.setLeftAnchor((Node)l, (Double)(div2 - LINE_WIDTH / 2.0));
        AnchorPane.setLeftAnchor((Node)z, (Double)(div2 - 20.0));
        answer.getChildren().addAll((Object[])new Node[]{con, z, l});
        answer.setPrefWidth(40.0);
        return answer;
    }

    private Parent createToffoliNode(Toffoli toffoli) {
        double div2 = 20.0;
        int midx = toffoli.getMainQubitIndex();
        int idx2 = toffoli.getSecondQubit();
        int idx3 = toffoli.getThirdQubit();
        AnchorPane answer = new AnchorPane();
        Circle con = new Circle(0.0, 0.0, 5.0, (Paint)Color.DARKGREY);
        con.setTranslateY(-5.0);
        Circle con2 = new Circle(0.0, 0.0, 5.0, (Paint)Color.DARKGRAY);
        con2.setTranslateY(-5.0);
        Circle c = new Circle(0.0, 0.0, 10.0, (Paint)Color.TRANSPARENT);
        c.setTranslateY(-10.0);
        c.setStroke((Paint)Color.DARKGRAY);
        c.setStrokeWidth(2.0);
        Line l = new Line(0.0, 0.0, 0.0, (double)(77 * (idx3 - midx) + 10));
        l.setStrokeWidth(LINE_WIDTH);
        l.setStroke((Paint)Color.DARKGRAY);
        AnchorPane.setTopAnchor((Node)con, (Double)20.0);
        AnchorPane.setTopAnchor((Node)l, (Double)20.0);
        AnchorPane.setTopAnchor((Node)c, (Double)Double.valueOf(77 * (idx3 - midx) + 20));
        AnchorPane.setTopAnchor((Node)con2, (Double)Double.valueOf(77 * (idx2 - midx) + 20));
        AnchorPane.setLeftAnchor((Node)con2, (Double)(div2 - 5.0));
        AnchorPane.setLeftAnchor((Node)con, (Double)(div2 - 5.0));
        AnchorPane.setLeftAnchor((Node)l, (Double)(div2 - LINE_WIDTH / 2.0));
        AnchorPane.setLeftAnchor((Node)c, (Double)(div2 - 10.0));
        answer.getChildren().addAll((Object[])new Node[]{con, con2, c, l});
        answer.setPrefWidth(40.0);
        return answer;
    }

    void setDot() {
        this.setGraphic((Node)this.createDotGroup());
        this.setText("");
    }

    Group createDotGroup() {
        Group g = new Group();
        Circle c = new Circle(0.0, 0.0, 5.0, (Paint)Color.DARKGREY);
        g.getChildren().add((Object)c);
        this.setContentDisplay(ContentDisplay.CENTER);
        return g;
    }

    public String toString() {
        return "GateSymbol for gate " + this.gate + " add address " + super.toString();
    }

    public static enum ControlQubit {
        ON,
        OFF;

    }
}

