/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.render;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;
import org.redfx.strangefx.ui.Main;

public class Qubit3D
extends Group {
    private int currentStep = 0;
    private double mouseOldX;
    private double mouseOldY = 0.0;
    private final Rotate rotateX = new Rotate(0.0, Rotate.X_AXIS);
    private final Rotate rotateY = new Rotate(0.0, Rotate.Y_AXIS);
    private Group rodSphere;
    private final Rotate myRotate = new Rotate(90.0, 0.0, 0.0, 0.0, Rotate.Z_AXIS);

    public Qubit3D() {
        this.createQubit();
    }

    private void createQubit() {
        PerspectiveCamera camera = new PerspectiveCamera(true);
        camera.setNearClip(0.1);
        camera.setFarClip(10000.0);
        camera.getTransforms().addAll((Object[])new Transform[]{this.rotateX, this.rotateY, new Translate(0.0, 0.0, -200.0)});
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void incrementStep() {
        ++this.currentStep;
    }

    public void resetStep() {
        this.currentStep = 0;
    }

    public void flip() {
        this.myRotate.setAngle(-this.myRotate.getAngle());
    }

    public void show() {
        BorderPane bp = new BorderPane((Node)this);
        Scene scene = new Scene((Parent)bp, 300.0, 300.0);
        scene.getStylesheets().add((Object)Main.class.getResource("/styles.css").toExternalForm());
        Stage stage = new Stage();
        stage.setTitle("StrangeFX rendering");
        stage.setScene(scene);
        System.out.println("show stage...");
        stage.show();
        System.out.println("showed scene");
    }
}

