/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.simulator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Cnot;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.X;

public class RenderModel {
    private int nqubits;
    private double[] beginState;
    private ObservableList<Double> endStates = FXCollections.observableArrayList();
    private Map<Integer, Qubit[]> intermediateStates = new HashMap<Integer, Qubit[]>();
    private BooleanProperty refreshRequest = new SimpleBooleanProperty();
    private ObjectProperty<ArrayList<Step>> stepsProperty = new SimpleObjectProperty();
    private static RenderModel instance = new RenderModel();
    private ArrayList<Step> steps = new ArrayList();

    public RenderModel() {
    }

    public RenderModel(Program p) {
        this.nqubits = p.getNumberQubits();
        this.steps = new ArrayList(p.getNumberQubits());
        this.steps.addAll(p.getSteps());
    }

    @Deprecated
    public static RenderModel getInstance() {
        return instance;
    }

    public BooleanProperty refreshRequest() {
        return this.refreshRequest;
    }

    public ObservableList<Double> getEndStates() {
        return this.endStates;
    }

    public void setIntermediateProbabilities(Map<Integer, Qubit[]> intqubits) {
        this.intermediateStates = intqubits;
    }

    public Qubit[] getIntermediaStates(int idx) {
        return this.intermediateStates.get(idx);
    }

    public Map<Integer, Qubit> getIntermediateStatesByQubit(int qubitIndex) {
        HashMap<Integer, Qubit> answer = new HashMap<Integer, Qubit>();
        for (Integer idx : this.intermediateStates.keySet()) {
            Qubit[] row = this.intermediateStates.get(idx);
            answer.put(idx, row[qubitIndex]);
        }
        return answer;
    }

    public void setNQubits(int n) {
        this.nqubits = n;
        this.beginState = new double[n];
        this.steps = new ArrayList(n);
    }

    public int getNQubits() {
        return this.nqubits;
    }

    public ArrayList<Step> getSteps() {
        return this.steps;
    }

    public ObjectProperty<ArrayList<Step>> stepsProperty() {
        return this.stepsProperty;
    }

    public int getNumberOfSteps() {
        return this.steps.size();
    }

    public void updateGatesForQubit(int idx, ArrayList<Gate> gateList) {
        int length = gateList.size();
        for (int i = 0; i < length; ++i) {
            Optional<Gate> xGate;
            Gate g = gateList.get(i);
            if (g == null) continue;
            while (this.steps.size() < i + 1) {
                this.steps.add(new Step(new Gate[]{new Identity(idx)}));
            }
            Step step = this.steps.get(i);
            List exists = step.getGates();
            Gate removeMe = null;
            for (Gate exist : exists) {
                if (exist.getMainQubitIndex() != idx) continue;
                removeMe = exist;
            }
            if (removeMe != null) {
                step.removeGate(removeMe);
            }
            step.addGate(g);
            List allGates = step.getGates();
            Optional<Gate> ctrlGate = allGates.stream().filter(c -> c.getGroup().equals("partial")).findFirst();
            if (!ctrlGate.isPresent() || !(xGate = allGates.stream().filter(c -> c.getClass().equals(X.class)).findFirst()).isPresent()) continue;
            int cidx = ctrlGate.get().getMainQubitIndex();
            int xidx = xGate.get().getMainQubitIndex();
            System.err.println("CNOT!!");
            Cnot cnotGate = new Cnot(cidx, xidx);
            Identity iGate = new Identity(xidx);
            step.removeGate(ctrlGate.get());
            step.removeGate(xGate.get());
            step.addGate((Gate)cnotGate);
        }
    }
}

