/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.render;

import java.util.LinkedList;
import java.util.List;
import javafx.animation.TranslateTransition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Step;
import org.redfx.strangefx.render.Qubit3D;
import org.redfx.strangefx.ui.GateSymbol;
import org.redfx.strangefx.ui.Main;

public class RenderEngine
extends VBox {
    static final int stepSize = 200;
    int nSteps;
    private List<Qubit3D> qubits = new LinkedList<Qubit3D>();
    private static int counter = 0;

    public RenderEngine() {
        super(50.0);
        this.setPadding(new Insets(50.0));
        this.getStyleClass().add((Object)"qubit");
    }

    public static RenderEngine createNode(Program p) {
        RenderEngine answer = new RenderEngine();
        int nq = p.getNumberQubits();
        List steps = p.getSteps();
        answer.nSteps = steps.size();
        HBox[] pane = new HBox[nq];
        for (int i = 0; i < nq; ++i) {
            pane[i] = new HBox();
            pane[i].setAlignment(Pos.CENTER_LEFT);
            Line l = new Line(0.0, 0.0, 200.0, 0.0);
            l.getStyleClass().add((Object)"wire");
            Qubit3D qubit3D = new Qubit3D();
            pane[i].getChildren().addAll((Object[])new Node[]{qubit3D, l});
            qubit3D.translateXProperty().addListener(o -> {
                int cstep;
                int mystep = (int)((qubit3D.getTranslateX() - 1.0) / 200.0);
                if (mystep > (cstep = qubit3D.getCurrentStep())) {
                    qubit3D.incrementStep();
                    qubit3D.flip();
                }
            });
            answer.qubits.add(qubit3D);
            answer.getChildren().add((Object)pane[i]);
        }
        for (Step step : steps) {
            List gates = step.getGates();
            int idx = 0;
            for (Gate gate : gates) {
                int mqi = gate.getMainQubitIndex();
                GateSymbol symbol = GateSymbol.of(gate, false);
                symbol.setTranslateX(-200 + 200 * (idx + 1));
                pane[mqi].getChildren().add((Object)symbol);
                ++idx;
            }
        }
        return answer;
    }

    public void animate() {
        Qubit3D node = this.qubits.get(counter++ % this.qubits.size());
        TranslateTransition tt = new TranslateTransition(Duration.seconds((double)5.0), (Node)node);
        node.resetStep();
        tt.setFromX(0.0);
        tt.setByX((double)(this.nSteps * 200));
        tt.playFromStart();
    }

    public static void showCircuit(Program p) {
        System.out.println("will show circuit for " + p);
        RenderEngine re = RenderEngine.createNode(p);
        System.out.println("re = " + re);
        Scene scene = new Scene((Parent)re, 800.0, 600.0);
        scene.getStylesheets().add((Object)Main.class.getResource("/styles.css").toExternalForm());
        Stage stage = new Stage();
        stage.setTitle("StrangeFX rendering");
        stage.setScene(scene);
        System.out.println("show stage...");
        stage.show();
        System.out.println("showed scene");
    }
}

