/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.reder;

import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Step;
import org.redfx.strange.gate.X;
import org.redfx.strangefx.simulator.RenderModel;
import org.redfx.strangefx.ui.GateSymbol;
import org.redfx.strangefx.ui.QubitBoard;
import org.redfx.strangefx.ui.QubitFlow;

@DisplayName(value="Rendertests")
class RenderTests {
    RenderTests() {
    }

    private void startFX() {
        System.err.println("Start JavaFX framework...");
        Runnable r = new Runnable(){

            @Override
            public void run() {
                System.err.println("JavaFX Platform initialized");
            }
        };
        try {
            System.err.println("Startup JavaFX Platform");
            Platform.startup((Runnable)r);
            System.err.println("Startup JavaFX Platform done");
        }
        catch (IllegalStateException e) {
            System.err.println("Toolkit already initialized, ignore");
        }
    }

    @Test
    @DisplayName(value="createQubitBoard")
    void createQubitBoard() {
        System.err.println("CreateQubitBoard");
        RenderModel model = new RenderModel();
        QubitBoard qb = new QubitBoard(model);
    }

    @Test
    void modelProgramConstructor() {
        int origQubits = 3;
        Program p = new Program(origQubits, new Step[0]);
        RenderModel model = new RenderModel(p);
        int modelQubits = model.getNQubits();
        Assertions.assertEquals((int)origQubits, (int)modelQubits, (String)"Model and created program need to have same amount of qubits");
    }

    @Test
    void createQubitBoardWithQubits() {
        this.startFX();
        int origQubits = 3;
        Program p = new Program(origQubits, new Step[0]);
        RenderModel model = new RenderModel(p);
        QubitBoard qb = new QubitBoard(model);
    }

    @Test
    void createSingleStep() {
        this.startFX();
        Program p = new Program(1, new Step[0]);
        Step s = new Step(new Gate[0]);
        s.addGate((Gate)new X(0));
        p.addStep(s);
        RenderModel model = new RenderModel(p);
        QubitBoard qb = new QubitBoard(model);
        qb.layout();
        List flows = qb.getQubitFlows();
        Assertions.assertNotNull((Object)flows);
        Assertions.assertEquals((int)flows.size(), (int)1);
        QubitFlow flow = (QubitFlow)flows.get(0);
        Assertions.assertEquals((int)flow.getIndex(), (int)0);
        Pane gateRow = flow.getGateRow();
        Assertions.assertNotNull((Object)gateRow);
        Assertions.assertEquals((int)gateRow.getChildren().size(), (int)1);
        Node gateNode = (Node)gateRow.getChildren().get(0);
        Assertions.assertTrue((boolean)(gateNode instanceof GateSymbol));
        GateSymbol symbol = (GateSymbol)gateNode;
        Gate gate = symbol.getGate();
        Assertions.assertTrue((boolean)(gate instanceof X));
    }

    @Test
    void createSingleStepTwoqubits() {
        this.startFX();
        Program p = new Program(2, new Step[0]);
        Step s = new Step(new Gate[0]);
        s.addGate((Gate)new X(1));
        p.addStep(s);
        RenderModel model = new RenderModel(p);
        QubitBoard qb = new QubitBoard(model);
        qb.layout();
        List flows = qb.getQubitFlows();
        Assertions.assertNotNull((Object)flows);
        Assertions.assertEquals((int)flows.size(), (int)2);
        QubitFlow flow = (QubitFlow)flows.get(1);
        Assertions.assertEquals((int)flow.getIndex(), (int)1);
        Pane gateRow = flow.getGateRow();
        Assertions.assertNotNull((Object)gateRow);
        Assertions.assertEquals((int)gateRow.getChildren().size(), (int)1);
        Node gateNode = (Node)gateRow.getChildren().get(0);
        Assertions.assertTrue((boolean)(gateNode instanceof GateSymbol));
        GateSymbol symbol = (GateSymbol)gateNode;
        Gate gate = symbol.getGate();
        System.err.println("GATE = " + gate);
        Assertions.assertTrue((boolean)(gate instanceof X));
    }
}

