/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.local.SimpleQuantumExecutionEnvironment;
import org.redfx.strange.ui.render.BoardOverlay;
import org.redfx.strangefx.simulator.RenderModel;
import org.redfx.strangefx.ui.GateSymbol;
import org.redfx.strangefx.ui.QubitFlow;

public class QubitBoard
extends Group {
    private RenderModel model;
    private ObservableList<QubitFlow> wires = FXCollections.observableArrayList();
    private final int nQubits;
    private final VBox wiresBox = new VBox();
    private final List<Node> overlays = new LinkedList<Node>();

    public QubitBoard(RenderModel model) {
        this.model = model;
        this.nQubits = model.getNQubits();
        this.wiresBox.getChildren().setAll(this.wires);
        this.wires.addListener(o -> {
            this.wiresBox.getChildren().setAll(this.wires);
            model.refreshRequest().set(true);
        });
        model.stepsProperty().addListener(observable -> {
            this.processCircuit((ArrayList)model.stepsProperty().get());
            this.renderCircuit();
        });
        for (int i = 0; i < this.nQubits; ++i) {
            this.appendQubit();
        }
        this.getChildren().add((Object)this.wiresBox);
    }

    public void addOverlay(BoardOverlay overlay) {
        this.getChildren().add((Object)overlay);
    }

    public ObservableList<QubitFlow> getWires() {
        return this.wires;
    }

    public void appendQubit() {
        QubitFlow flow = new QubitFlow(this.wires.size(), this.model);
        this.wires.add((Object)flow);
    }

    public void clear() {
        this.wires.forEach(QubitFlow::clear);
        this.wires.removeIf(qb -> qb.getIndex() > this.nQubits - 1);
    }

    private void renderCircuit() {
        this.clear();
        for (Step step : this.model.getSteps()) {
            List gates = step.getGates();
            boolean[] gotit = new boolean[this.nQubits];
            for (Gate gate : gates) {
                int qb = gate.getMainQubitIndex();
                System.err.println("qb = " + qb);
                gotit[qb] = true;
                QubitFlow wire = (QubitFlow)((Object)this.wires.get(qb));
                wire.setMinWidth(480.0);
                System.err.println("Calling addGate");
                GateSymbol gateSymbol = wire.addGate(gate);
            }
        }
    }

    public List<QubitFlow> getQubitFlows() {
        return this.wires;
    }

    private void processCircuit(ArrayList<Step> steps) {
        System.err.println("Process circuit with " + this.wires.size() + " qubits and " + steps.size() + " steps.");
        Program p = new Program(this.wires.size(), new Step[0]);
        for (Step step : steps) {
            System.err.println("Step: " + step);
            p.addStep(step);
        }
        SimpleQuantumExecutionEnvironment qee = new SimpleQuantumExecutionEnvironment();
        Consumer<Result> resultConsumer = t -> Platform.runLater(() -> {
            Qubit[] qubits = t.getQubits();
            ObservableList<Double> endStates = this.model.getEndStates();
            for (int i = 0; i < this.wires.size(); ++i) {
                if (endStates.size() > i) {
                    endStates.set(i, (Object)qubits[i].getProbability());
                    continue;
                }
                endStates.add(i, (Object)qubits[i].getProbability());
            }
        });
        qee.runProgram(p, resultConsumer);
    }

    public void redraw() {
        this.wires.forEach(w -> w.redraw());
    }
}

