/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.ui;

import javafx.scene.Group;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.redfx.strange.Complex;
import org.redfx.strange.Program;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strangefx.ui.PseudoGate;

public class ProbabilitiesGate
extends PseudoGate {
    private Step step;

    public ProbabilitiesGate(Step step) {
        this.step = step;
    }

    public Region createUI() {
        System.err.println("Prob for step " + this.step.getIndex());
        Program program = this.step.getProgram();
        Result result = program.getResult();
        Complex[] ip = result.getIntermediateProbability(this.step.getIndex());
        int nq = program.getNumberQubits();
        int N = 1 << nq;
        double deltaY = (66.0 * (double)nq - 10.0 + 38.0) / (double)N;
        System.err.println("n = " + nq + " and N = " + N + ", dY = " + deltaY);
        Group answer = new Group();
        Rectangle rect2 = new Rectangle(0.0, 0.0, 40.0, (double)(66 * nq - 10 + 38));
        rect2.setFill((Paint)Color.WHITE);
        rect2.setStroke((Paint)Color.BLUE);
        rect2.setStrokeWidth(1.0);
        answer.getChildren().add((Object)rect2);
        for (int i = 0; i < N; ++i) {
            double startY = (double)i * deltaY;
            Rectangle minibar = new Rectangle(1.0, (double)i * deltaY, 38.0 * ip[i].abssqr(), deltaY - 1.0);
            minibar.setFill((Paint)Color.GREEN);
            Line l = new Line(1.0, startY, 39.0, startY);
            l.setFill((Paint)Color.LIGHTGRAY);
            l.setStrokeWidth(1.0);
            answer.getChildren().add((Object)l);
            answer.getChildren().add((Object)minibar);
        }
        Pane region = new Pane();
        region.getChildren().add((Object)answer);
        return region;
    }
}

