/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.demo;

import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.gate.X;
import org.redfx.strange.local.SimpleQuantumExecutionEnvironment;
import org.redfx.strangefx.render.RenderEngine;
import org.redfx.strangefx.ui.Main;

public class RenderDemo
extends Application {
    BorderPane borderPane = new BorderPane();

    public void start(Stage stage) throws Exception {
        Scene scene = new Scene((Parent)this.borderPane, 800.0, 600.0);
        scene.getStylesheets().add((Object)Main.class.getResource("/styles.css").toExternalForm());
        this.simulate();
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])new String[0]);
    }

    private void simulate() {
        Program p = new Program(2, new Step[0]);
        Step s1 = new Step(new Gate[0]);
        s1.addGate((Gate)new X(0));
        p.addStep(s1);
        Step s2 = new Step(new Gate[0]);
        s2.addGate((Gate)new X(1));
        p.addStep(s2);
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result res = sqee.runProgram(p);
        Qubit[] qubits = res.getQubits();
        RenderEngine sim = RenderEngine.createNode(p);
        this.borderPane.setCenter((Node)sim);
        Button button = new Button("uh?");
        button.setOnAction(e -> sim.animate());
        this.borderPane.setTop((Node)button);
    }
}

