/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.simulator.local;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.local.SimpleQuantumExecutionEnvironment;
import org.redfx.strangefx.simulator.CloudSimulator;
import org.redfx.strangefx.simulator.RenderModel;
import org.redfx.strangefx.simulator.Simulator;

public class LocalSimulator
implements Simulator {
    private final int LOCAL_TRESHOLD = 1;
    private final RenderModel renderModel;
    CloudSimulator cloudSimulator = new CloudSimulator();

    public LocalSimulator(RenderModel model) {
        this.renderModel = model;
        model.refreshRequest().addListener((obs, oldv, newv) -> {
            if (newv.booleanValue()) {
                this.calculate();
            }
            model.refreshRequest().set(false);
        });
    }

    private void calculate() {
        int nq = this.renderModel.getNQubits();
        Program p = new Program(nq, new Step[0]);
        int nsteps = this.renderModel.getNumberOfSteps();
        for (Step step : this.convertRenderSteps(this.renderModel.getSteps())) {
            p.addStep(step);
            SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
            Result res = sqee.runProgram(p);
            Qubit[] qubits = res.getQubits();
            ArrayList<Double> probability = new ArrayList<Double>();
            for (Qubit qubit : qubits) {
                probability.add(qubit.getProbability());
            }
            ObservableList<Double> endStates = this.renderModel.getEndStates();
            endStates.setAll(probability);
        }
    }

    public List<Step> convertRenderSteps(List<Step> renderSteps) {
        ArrayList<Step> answer = new ArrayList<Step>(renderSteps.size());
        for (Step renderStep : renderSteps) {
            Step s = new Step(new Gate[0]);
            answer.add(s);
            for (Gate gate : renderStep.getGates()) {
                if ("partial".equals(gate.getGroup())) {
                    s.addGate((Gate)new Identity(gate.getMainQubitIndex()));
                    continue;
                }
                s.addGate(gate);
            }
        }
        return answer;
    }

    @Override
    public Complex[] calculateResults(Gate[][] gates) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Complex[] calculateResults(RenderModel m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] calculateQubitStates(RenderModel m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

