/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.render;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.Oracle;
import org.redfx.strange.local.SimpleQuantumExecutionEnvironment;
import org.redfx.strange.simulator.Model;
import org.redfx.strange.ui.GateSymbol;
import org.redfx.strange.ui.Main;
import org.redfx.strange.ui.QubitBoard;
import org.redfx.strange.ui.QubitFlow;
import org.redfx.strange.ui.render.BoardOverlay;

public class Renderer {
    private static Stage myStage;

    public static void renderProgram(Program p) {
        Platform.runLater(() -> Renderer.showProgram(p));
    }

    public static void showProbabilities(Program p, int count) {
        int i;
        System.err.println("SHOWPROB, count = " + count);
        SimpleQuantumExecutionEnvironment simulator = new SimpleQuantumExecutionEnvironment();
        int nq = p.getNumberQubits();
        int[] counter = new int[1 << nq];
        for (i = 0; i < count; ++i) {
            int prob;
            Result result = simulator.runProgram(p);
            int n = prob = result.getMeasuredProbability();
            counter[n] = counter[n] + 1;
        }
        for (i = 0; i < counter.length; ++i) {
            System.err.println("cnt [" + i + "]: " + counter[i]);
        }
        Platform.runLater(() -> Renderer.renderMeasuredProbabilities(counter));
    }

    public static QubitBoard getRenderGroup(Program program) {
        int nQubits = program.getNumberQubits();
        QubitBoard board = new QubitBoard(nQubits);
        LinkedList<GateSymbol> multiWires = new LinkedList<GateSymbol>();
        LinkedList<GateSymbol> probabilities = new LinkedList<GateSymbol>();
        LinkedList<BoardOverlay> boardOverlays = new LinkedList<BoardOverlay>();
        ObservableList<QubitFlow> wires = board.getWires();
        for (Step s : program.getSteps()) {
            boolean[] gotit = new boolean[nQubits];
            for (Gate gate : s.getGates()) {
                BoardOverlay overlay;
                int qb = gate.getMainQubitIndex();
                gotit[qb] = true;
                QubitFlow wire = (QubitFlow)((Object)wires.get(qb));
                wire.setMinWidth(480.0);
                GateSymbol symbol = wire.addGate(gate);
                if (symbol.spanWires > 1) {
                    if (gate instanceof Oracle) {
                        multiWires.add(symbol);
                        overlay = new BoardOverlay(s, symbol);
                        boardOverlays.add(overlay);
                        board.addOverlay(overlay);
                    } else {
                        int idx = 0;
                        List aff = gate.getAffectedQubitIndexes().stream().filter(e -> e != qb).collect(Collectors.toList());
                        Iterator iterator = aff.iterator();
                        while (iterator.hasNext()) {
                            int a = (Integer)iterator.next();
                            QubitFlow q = (QubitFlow)((Object)wires.get(a));
                            GateSymbol symbol2 = q.addAdditonalGateSymbol(gate, ++idx);
                            gotit[a] = true;
                            BoardOverlay overlay2 = new BoardOverlay(s, symbol, symbol2);
                            boardOverlays.add(overlay2);
                            board.addOverlay(overlay2);
                        }
                    }
                }
                if (!symbol.probability) continue;
                probabilities.add(symbol);
                overlay = new BoardOverlay(s, symbol);
                boardOverlays.add(overlay);
                board.addOverlay(overlay);
            }
            for (int i = 0; i < nQubits; ++i) {
                if (gotit[i]) continue;
                QubitFlow wire = (QubitFlow)((Object)wires.get(i));
                wire.addGate((Gate)new Identity());
            }
        }
        ObservableList<Double> endStates = Model.getInstance().getEndStates();
        Qubit[] qubits = program.getResult().getQubits();
        Complex[] probability = program.getResult().getProbability();
        Object[] endValues = new Double[probability.length];
        int idx = 0;
        for (Qubit qubit : qubits) {
            endValues[idx++] = qubit.getProbability();
        }
        endStates.setAll(endValues);
        return board;
    }

    public static void disable(QubitBoard board) {
        board.getWires().stream().forEach(flow -> flow.cleanup());
    }

    public static void showProgram(Program program) {
        Stage stage;
        myStage = stage = new Stage();
        stage.setTitle("StrangeFX");
        QubitBoard board = Renderer.getRenderGroup(program);
        VBox vbox = new VBox(40.0);
        vbox.getChildren().add((Object)board);
        Scene scene = new Scene((Parent)vbox);
        scene.getStylesheets().add((Object)Main.class.getResource("/styles.css").toExternalForm());
        stage.setScene(scene);
        stage.show();
    }

    public static void renderMeasuredProbabilities(int[] results) {
        CategoryAxis xAxis = new CategoryAxis();
        NumberAxis yAxis = new NumberAxis();
        BarChart barChart = new BarChart((Axis)xAxis, (Axis)yAxis);
        barChart.setData(Renderer.getChartData(results));
        barChart.setTitle("Measured probability distribution");
        StackPane root = new StackPane();
        root.getChildren().add((Object)barChart);
        if (myStage != null) {
            Scene oldscene = myStage.getScene();
            VBox box = (VBox)oldscene.getRoot();
            oldscene.setRoot((Parent)new StackPane());
            box.getChildren().add((Object)root);
            Scene newScene = new Scene((Parent)box);
            newScene.getStylesheets().add((Object)Main.class.getResource("/styles.css").toExternalForm());
            myStage.setScene(newScene);
        } else {
            Stage stage = new Stage();
            stage.setScene(new Scene((Parent)root, 640.0, 480.0));
            stage.show();
        }
    }

    private static ObservableList<XYChart.Series<String, Integer>> getChartData(int[] results) {
        ObservableList answer = FXCollections.observableArrayList();
        XYChart.Series series = new XYChart.Series();
        series.setName("occurences");
        answer.add((Object)series);
        for (int i = 0; i < results.length; ++i) {
            series.getData().add((Object)new XYChart.Data((Object)Renderer.getFixedBinaryString(i, (int)(Math.log(results.length) / Math.log(2.0))), (Object)results[i]));
        }
        return answer;
    }

    private static String getFixedBinaryString(int i, int w) {
        StringBuffer buff = new StringBuffer(Integer.toBinaryString(i));
        while (buff.length() < w) {
            buff.insert(0, "0");
        }
        return buff.toString();
    }

    static {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                System.err.println("JavaFX Platform initialized");
            }
        };
        try {
            Platform.startup((Runnable)r);
        }
        catch (IllegalStateException e) {
            System.err.println("Toolkit already initialized, ignore");
        }
    }
}

