/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.render;

import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.DrawMode;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;
import org.fxyz3d.geometry.Point3D;
import org.fxyz3d.shapes.primitives.FrustumMesh;
import org.fxyz3d.shapes.primitives.SegmentedSphereMesh;
import org.redfx.strange.ui.Main;

public class Qubit3D
extends Group {
    private int currentStep = 0;
    private double mouseOldX;
    private double mouseOldY = 0.0;
    private final Rotate rotateX = new Rotate(0.0, Rotate.X_AXIS);
    private final Rotate rotateY = new Rotate(0.0, Rotate.Y_AXIS);
    private Group rodSphere;
    private final Rotate myRotate = new Rotate(90.0, 0.0, 0.0, 0.0, Rotate.Z_AXIS);

    public Qubit3D() {
        this.createQubit();
    }

    private void createQubit() {
        PerspectiveCamera camera = new PerspectiveCamera(true);
        camera.setNearClip(0.1);
        camera.setFarClip(10000.0);
        camera.getTransforms().addAll((Object[])new Transform[]{this.rotateX, this.rotateY, new Translate(0.0, 0.0, -200.0)});
        FrustumMesh plane = new FrustumMesh(50.0, 50.0, 1.0, 1, new Point3D(0.0f, -0.5f, 0.0f), new Point3D(0.0f, 0.5f, 0.0f));
        plane.setMaterial((Material)new PhongMaterial(Color.web((String)"#ccdd3320")));
        SegmentedSphereMesh innerSphere = new SegmentedSphereMesh(40, 0, 0, 50.0, new Point3D(0.0f, 0.0f, 0.0f));
        innerSphere.setMaterial((Material)new PhongMaterial(Color.web((String)"#ff800080")));
        SegmentedSphereMesh frameSphere = new SegmentedSphereMesh(20, 0, 0, 50.0, new Point3D(0.0f, 0.0f, 0.0f));
        frameSphere.setMaterial((Material)new PhongMaterial(Color.BLACK));
        frameSphere.setDrawMode(DrawMode.LINE);
        FrustumMesh rod = new FrustumMesh(2.0, 2.0, 1.0, 1, new Point3D(0.0f, 0.0f, 0.0f), new Point3D(50.0f, 0.0f, 0.0f));
        rod.setMaterial((Material)new PhongMaterial(Color.web((String)"#0080ff")));
        SegmentedSphereMesh smallSphere = new SegmentedSphereMesh(20, 0, 0, 4.0, new Point3D(50.0f, 0.0f, 0.0f));
        smallSphere.setMaterial((Material)new PhongMaterial(Color.web((String)"#0080ff")));
        this.rodSphere = new Group(new Node[]{smallSphere, rod});
        Group group = new Group(new Node[]{plane, this.rodSphere, innerSphere, frameSphere, new AmbientLight(Color.BISQUE)});
        SubScene subScene = new SubScene((Parent)group, 100.0, 100.0, true, SceneAntialiasing.BALANCED);
        subScene.setCamera((Camera)camera);
        subScene.setOnMousePressed(event -> {
            this.mouseOldX = event.getSceneX();
            this.mouseOldY = event.getSceneY();
        });
        subScene.setOnMouseDragged(event -> {
            this.rotateX.setAngle(this.rotateX.getAngle() - (event.getSceneY() - this.mouseOldY));
            this.rotateY.setAngle(this.rotateY.getAngle() + (event.getSceneX() - this.mouseOldX));
            this.mouseOldX = event.getSceneX();
            this.mouseOldY = event.getSceneY();
        });
        this.getChildren().add((Object)subScene);
        this.rodSphere.getTransforms().setAll((Object[])new Transform[]{this.myRotate});
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void incrementStep() {
        ++this.currentStep;
    }

    public void resetStep() {
        this.currentStep = 0;
    }

    public void flip() {
        this.myRotate.setAngle(-this.myRotate.getAngle());
    }

    public void show() {
        BorderPane bp = new BorderPane((Node)this);
        Scene scene = new Scene((Parent)bp, 300.0, 300.0);
        scene.getStylesheets().add((Object)Main.class.getResource("/styles.css").toExternalForm());
        Stage stage = new Stage();
        stage.setTitle("StrangeFX rendering");
        stage.setScene(scene);
        System.out.println("show stage...");
        stage.show();
        System.out.println("showed scene");
    }
}

