/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.ui.render;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.ui.GateSymbol;

public class BoardOverlay
extends Region {
    private GateSymbol symbol;
    private GateSymbol symbol2;

    public BoardOverlay(Step s, GateSymbol symbol) {
        System.err.println("Create BO, s = " + s);
        this.symbol = symbol;
        if (symbol.probability) {
            this.createProbability(s, symbol);
        } else {
            this.createOracle(symbol);
        }
    }

    public BoardOverlay(Step s, GateSymbol symbol1, GateSymbol symbol2) {
        this.symbol = symbol1;
        this.symbol2 = symbol2;
        Line line = new Line(0.0, 0.0, 0.0, 0.0);
        this.getChildren().add((Object)line);
        line.setStroke((Paint)Color.BLUE);
        line.setStrokeWidth(1.0);
        InvalidationListener il = this.createLineInvalidationListener(line);
        this.symbol.boundsInParentProperty().addListener(il);
        this.symbol2.boundsInParentProperty().addListener(il);
    }

    private InvalidationListener createLineInvalidationListener(final Line line) {
        InvalidationListener answer = new InvalidationListener(){

            public void invalidated(Observable observable) {
                Bounds bp = BoardOverlay.this.symbol.getBoundsInParent();
                Bounds bp2 = BoardOverlay.this.symbol2.getBoundsInParent();
                Point2D beginPoint = BoardOverlay.this.symbol.localToScene(BoardOverlay.this.symbol.getWidth() / 2.0, BoardOverlay.this.symbol.getHeight() / 2.0);
                Point2D endPoint = BoardOverlay.this.symbol2.localToScene(BoardOverlay.this.symbol2.getWidth() / 2.0, BoardOverlay.this.symbol2.getHeight() / 2.0);
                line.setStartX(beginPoint.getX());
                line.setStartY(beginPoint.getY());
                line.setEndX(endPoint.getX());
                line.setEndY(endPoint.getY());
            }
        };
        return answer;
    }

    private void createProbability(Step s, final GateSymbol symbol) {
        Gate gate = symbol.getGate();
        System.err.println("Prob for step " + s.getIndex());
        Program program = s.getProgram();
        Result result = program.getResult();
        final Complex[] ip = result.getIntermediateProbability(s.getIndex());
        System.err.println(" = " + ip[3].abssqr());
        final int nq = program.getNumberQubits();
        final int N = 1 << nq;
        final double deltaY = (66.0 * (double)nq - 10.0 + 38.0) / (double)N;
        System.err.println("n = " + nq + " and N = " + N + ", dY = " + deltaY);
        this.symbol.boundsInParentProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                BoardOverlay me = BoardOverlay.this;
                me.getChildren().clear();
                Bounds bp = symbol.getBoundsInParent();
                Point2D base = symbol.localToScene(0.0, 0.0);
                Rectangle rect2 = new Rectangle(base.getX(), base.getY(), 40.0, (double)(66 * nq - 10 + 38));
                rect2.setFill((Paint)Color.WHITE);
                rect2.setStroke((Paint)Color.BLUE);
                rect2.setStrokeWidth(1.0);
                BoardOverlay.this.getChildren().add((Object)rect2);
                for (int i = 0; i < N; ++i) {
                    double startY = base.getY() + (double)i * deltaY;
                    Rectangle minibar = new Rectangle(1.0 + base.getX(), base.getY() + (double)i * deltaY, 38.0 * ip[i].abssqr(), deltaY - 1.0);
                    minibar.setFill((Paint)Color.GREEN);
                    Line l = new Line(1.0 + base.getX(), startY, base.getX() + 39.0, startY);
                    l.setFill((Paint)Color.LIGHTGRAY);
                    l.setStrokeWidth(1.0);
                    BoardOverlay.this.getChildren().add((Object)l);
                    BoardOverlay.this.getChildren().add((Object)minibar);
                }
            }
        });
    }

    private void createOracle(final GateSymbol symbol) {
        this.symbol.boundsInParentProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                BoardOverlay me = BoardOverlay.this;
                me.getChildren().clear();
                Bounds bp = symbol.getBoundsInParent();
                Point2D base = symbol.localToScene(0.0, 0.0);
                Rectangle rect = new Rectangle(base.getX(), 38.0 + base.getY(), 40.0, (double)(66 * symbol.spanWires - 10));
                Rectangle rect2 = new Rectangle(base.getX(), base.getY(), 40.0, (double)(66 * symbol.spanWires - 10 + 38));
                rect.setFill((Paint)Color.YELLOWGREEN);
                rect2.setStroke((Paint)Color.GREEN);
                rect2.setStrokeWidth(2.0);
                rect2.setFill((Paint)Color.TRANSPARENT);
                BoardOverlay.this.getChildren().setAll((Object[])new Node[]{rect, rect2});
            }
        });
    }
}

