/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.ui;

import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.Dragboard;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Line;
import org.redfx.strange.Gate;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.Oracle;
import org.redfx.strange.simulator.Model;
import org.redfx.strange.ui.GateSymbol;
import org.redfx.strange.ui.Measurement;

public class QubitFlow
extends Region {
    private boolean askOnTop = false;
    private static GateSymbol SPACER = new GateSymbol((Gate)new Identity(0), false){
        {
            this.getStyleClass().setAll((Object[])new String[]{"gate-spacer"});
            int SPACER_WIDTH = 5;
            this.setMaxWidth(SPACER_WIDTH);
            this.setMinWidth(SPACER_WIDTH);
            this.setText(null);
        }
    };
    private Line line = new Line();
    private Line measuredLine = new Line();
    private Label title = new Label();
    private Measurement measurement = new Measurement();
    private HBox gateRow = new HBox();
    private HBox allGates = new HBox();
    private int idx;
    private ObservableList<GateSymbol> gates = FXCollections.observableArrayList();
    private Region oldParent = null;
    private final Model model = Model.getInstance();
    private InvalidationListener endStateListener = o -> {
        double mv = (Double)this.model.getEndStates().get(this.idx);
        this.measurement.setMeasuredChance(mv);
    };

    public QubitFlow(int index) {
        this.idx = index;
        this.title.setText(String.format("q[%d] I0>", this.idx));
        this.gateRow.getChildren().add((Object)SPACER);
        this.getStyleClass().add((Object)"qubit");
        this.gateRow.getStyleClass().add((Object)"gate-row");
        this.title.getStyleClass().add((Object)"title");
        this.title.setPrefWidth(85.0);
        this.line.endXProperty().bind((ObservableValue)this.widthProperty());
        this.line.getStyleClass().add((Object)"wire");
        this.measuredLine.endXProperty().bind((ObservableValue)this.widthProperty());
        this.measuredLine.getStyleClass().add((Object)"wire");
        this.measuredLine.setVisible(false);
        BorderPane base = new BorderPane();
        base.getStyleClass().add((Object)"base");
        base.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        base.setLeft((Node)this.title);
        base.setCenter((Node)this.allGates);
        HBox transparent = new HBox();
        transparent.setOpacity(0.01);
        transparent.setPrefWidth(1024.0);
        this.allGates.getChildren().addAll((Object[])new Node[]{this.gateRow, transparent});
        HBox.setHgrow((Node)transparent, (Priority)Priority.ALWAYS);
        base.setRight((Node)this.measurement);
        BorderPane.setAlignment((Node)this.title, (Pos)Pos.CENTER);
        BorderPane.setAlignment((Node)this.measurement, (Pos)Pos.CENTER);
        this.measuredLine.setTranslateY(10.0);
        StackPane stack = new StackPane(new Node[]{this.line, this.measuredLine, base});
        this.sceneProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (QubitFlow.this.getScene() != null) {
                    QubitFlow.this.prefWidthProperty().bind((ObservableValue)QubitFlow.this.getScene().widthProperty());
                }
            }
        });
        stack.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        stack.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)stack);
        this.gateRow.getChildren().setAll(this.getGateSymbols());
        this.gateRow.getChildren().addListener(observable -> this.getGateSymbols().setAll((Collection)this.gateRow.getChildren().stream().filter(g -> g != SPACER).filter(g -> g instanceof GateSymbol).map(n -> (GateSymbol)((Object)((Object)n))).collect(Collectors.toList())));
        this.gateRow.setOnDragOver(event -> {
            if (event.getGestureSource() != this && event.getDragboard().getContent(GateSymbol.DRAGGABLE_GATE) != null) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                if (this.gateRow.getChildren().isEmpty()) {
                    this.gateRow.getChildren().add((Object)SPACER);
                } else {
                    PickResult pickResult = event.getPickResult();
                    Node intersectedNode = pickResult.getIntersectedNode();
                    double x = pickResult.getIntersectedPoint().getX();
                    if (intersectedNode instanceof GateSymbol && intersectedNode != SPACER) {
                        this.removeSpacer();
                        int nodeIndex = this.gateRow.getChildren().indexOf((Object)intersectedNode);
                        int insertionIndex = x <= ((GateSymbol)intersectedNode).getWidth() / 2.0 ? nodeIndex : nodeIndex + 1;
                        this.gateRow.getChildren().add(insertionIndex, (Object)SPACER);
                    } else if (intersectedNode == this.gateRow && x >= this.getOccupiedWidth() && this.gateRow.getChildren().indexOf((Object)SPACER) < this.gateRow.getChildren().size()) {
                        this.removeSpacer();
                        this.gateRow.getChildren().add((Object)SPACER);
                    }
                }
            }
            event.consume();
        });
        this.gateRow.setOnDragDropped(e -> {
            Dragboard db = e.getDragboard();
            if (db.hasContent(GateSymbol.DRAGGABLE_GATE)) {
                GateSymbol symbol = (GateSymbol)((Object)((Object)System.getProperties().get(GateSymbol.DRAGGABLE_GATE)));
                if (TransferMode.MOVE == e.getTransferMode()) {
                    symbol.removeFromParent();
                    int spacerIndex = this.gateRow.getChildren().indexOf((Object)SPACER);
                    this.gateRow.getChildren().set(spacerIndex, (Object)symbol);
                    e.setDropCompleted(true);
                } else {
                    symbol = GateSymbol.of(symbol.getGate());
                    int spacerIndex = this.gateRow.getChildren().indexOf((Object)SPACER);
                    this.gateRow.getChildren().set(spacerIndex, (Object)symbol);
                    e.setDropCompleted(true);
                }
            }
            e.consume();
        });
        this.gateRow.setOnDragExited(e -> this.removeSpacer());
        this.model.getEndStates().addListener(this.endStateListener);
        this.gates.addListener(o -> this.model.setGatesForCircuit(this.idx, this.gates.stream().map(gs -> this.createGate(gs.getGate())).collect(Collectors.toList())));
    }

    public void cleanup() {
        this.model.getEndStates().removeListener(this.endStateListener);
    }

    private void removeSpacer() {
        this.gateRow.getChildren().remove((Object)SPACER);
    }

    public boolean wantsOnTop() {
        return this.askOnTop;
    }

    public GateSymbol addGate(Gate gate) {
        int spacerIndex;
        if (this.gateRow.getChildren().isEmpty()) {
            this.gateRow.getChildren().add((Object)SPACER);
        }
        GateSymbol symbol = GateSymbol.of(gate);
        if (gate instanceof Oracle) {
            this.askOnTop = true;
        }
        if ((spacerIndex = this.gateRow.getChildren().indexOf((Object)SPACER)) < 0) {
            this.gateRow.getChildren().add((Object)symbol);
        } else {
            this.gateRow.getChildren().set(spacerIndex, (Object)symbol);
        }
        if (gate instanceof org.redfx.strange.gate.Measurement) {
            this.measuredLine.translateXProperty().bind((ObservableValue)symbol.layoutXProperty().add((ObservableNumberValue)this.allGates.layoutXProperty()));
            this.measuredLine.setVisible(true);
        }
        return symbol;
    }

    public GateSymbol addAdditonalGateSymbol(Gate gate, int gateidx) {
        if (this.gateRow.getChildren().isEmpty()) {
            this.gateRow.getChildren().add((Object)SPACER);
        }
        GateSymbol symbol = GateSymbol.of(gate, gateidx);
        int spacerIndex = this.gateRow.getChildren().indexOf((Object)SPACER);
        if (spacerIndex < 0) {
            this.gateRow.getChildren().add((Object)symbol);
        } else {
            this.gateRow.getChildren().set(spacerIndex, (Object)symbol);
        }
        return symbol;
    }

    private double getOccupiedWidth() {
        double width = 0.0;
        for (Node node : this.gateRow.getChildren()) {
            width += ((GateSymbol)node).getWidth();
        }
        return width + this.gateRow.getSpacing() * (double)this.gateRow.getChildren().size();
    }

    public int getIndex() {
        return this.idx;
    }

    public ObservableList<GateSymbol> getGateSymbols() {
        return this.gates;
    }

    public void clear() {
        this.model.getEndStates().removeListener(this.endStateListener);
        this.gateRow.getChildren().clear();
    }

    public Measurement getOutput() {
        return this.measurement;
    }

    private Gate createGate(Gate g) {
        return g;
    }
}

