/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.ui;

import java.util.LinkedList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.redfx.strange.simulator.Model;
import org.redfx.strange.ui.QubitFlow;
import org.redfx.strange.ui.render.BoardOverlay;

public class QubitBoard
extends Group {
    private Model model = Model.getInstance();
    private ObservableList<QubitFlow> wires = FXCollections.observableArrayList();
    private final int initialQubitNumber;
    private final VBox wiresBox = new VBox();
    private final List<Node> overlays = new LinkedList<Node>();

    public QubitBoard(int initialQubitNumber) {
        this.initialQubitNumber = initialQubitNumber;
        this.wiresBox.getChildren().setAll(this.wires);
        this.wires.addListener(o -> {
            this.wiresBox.getChildren().setAll(this.wires);
            this.model.setNQubits(this.wires.size());
            this.model.refreshRequest().set(true);
        });
        for (int i = 0; i < initialQubitNumber; ++i) {
            this.appendQubit();
        }
        this.getChildren().add((Object)this.wiresBox);
    }

    public void addOverlay(BoardOverlay overlay) {
        this.getChildren().add((Object)overlay);
    }

    public ObservableList<QubitFlow> getWires() {
        return this.wires;
    }

    public void appendQubit() {
        this.wires.add((Object)new QubitFlow(this.wires.size()));
    }

    public void clear() {
        this.wires.forEach(QubitFlow::clear);
        this.wires.removeIf(qb -> qb.getIndex() > this.initialQubitNumber - 1);
    }
}

