/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.ui;

import java.util.Map;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import org.redfx.strange.Gate;
import org.redfx.strange.gate.Cnot;
import org.redfx.strange.gate.Cz;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.Oracle;
import org.redfx.strange.gate.ProbabilitiesGate;
import org.redfx.strange.gate.Toffoli;

public class GateSymbol
extends Label {
    static final DataFormat DRAGGABLE_GATE = new DataFormat(new String[]{"draggable-gate"});
    private final Gate gate;
    private final boolean movable;
    public int spanWires = 1;
    public boolean probability = false;

    public static GateSymbol of(Gate gate, Boolean movable) {
        return new GateSymbol(gate, movable, 0);
    }

    public static GateSymbol of(Gate gate) {
        return new GateSymbol(gate, true, 0);
    }

    public static GateSymbol of(Gate gate, int idx) {
        return new GateSymbol(gate, true, idx);
    }

    GateSymbol(Gate gate, boolean movable) {
        this(gate, movable, 0);
    }

    void setDot() {
        Group g = new Group();
        Circle c = new Circle(0.0, 0.0, 5.0, (Paint)Color.DARKGREY);
        g.getChildren().add((Object)c);
        this.setContentDisplay(ContentDisplay.CENTER);
        this.setGraphic((Node)g);
        this.setText("");
    }

    GateSymbol(Gate gate, boolean movable, int idx) {
        this.spanWires = gate.getAffectedQubitIndexes().size();
        this.gate = Objects.requireNonNull(gate);
        this.movable = movable;
        if (!(gate instanceof Identity)) {
            Group g;
            if (gate instanceof Cnot) {
                if (idx == 0) {
                    this.setDot();
                } else {
                    g = new Group();
                    Circle c = new Circle(0.0, 0.0, 10.0, (Paint)Color.TRANSPARENT);
                    c.setStroke((Paint)Color.DARKGRAY);
                    c.setStrokeWidth(2.0);
                    Line l = new Line(0.0, -10.0, 0.0, 10.0);
                    l.setStrokeWidth(2.0);
                    l.setStroke((Paint)Color.DARKGRAY);
                    g.getChildren().addAll((Object[])new Node[]{c, l});
                    this.setContentDisplay(ContentDisplay.CENTER);
                    this.setGraphic((Node)g);
                    this.setText("");
                }
            } else if (gate instanceof Toffoli) {
                if (idx == 0 || idx == 1) {
                    this.setDot();
                } else {
                    g = new Group();
                    Circle c = new Circle(0.0, 0.0, 10.0, (Paint)Color.TRANSPARENT);
                    c.setStroke((Paint)Color.DARKGRAY);
                    c.setStrokeWidth(2.0);
                    Line l = new Line(0.0, -10.0, 0.0, 10.0);
                    l.setStrokeWidth(2.0);
                    l.setStroke((Paint)Color.DARKGRAY);
                    g.getChildren().addAll((Object[])new Node[]{c, l});
                    this.setContentDisplay(ContentDisplay.CENTER);
                    this.setGraphic((Node)g);
                    this.setText("");
                }
            } else if (idx == 0 && gate instanceof Cz) {
                this.setDot();
            } else {
                this.getStyleClass().setAll((Object[])new String[]{"gate-symbol", this.getStyle(gate.getGroup())});
                this.setText(gate.getCaption());
            }
        }
        this.setMinWidth(40.0);
        this.setAlignment(Pos.CENTER);
        if (gate instanceof Oracle) {
            Oracle oracle = (Oracle)gate;
            this.spanWires = oracle.getQubits();
            this.setOpacity(0.9);
        }
        if (gate instanceof ProbabilitiesGate) {
            this.probability = true;
        }
        if (movable) {
            this.setContextMenu(this.buildContextMenu());
        }
        this.setOnDragDetected(e -> {
            System.getProperties().put(DRAGGABLE_GATE, (Object)this);
            Dragboard db = this.startDragAndDrop(new TransferMode[]{this.isMovable() ? TransferMode.MOVE : TransferMode.COPY});
            db.setDragView((Image)this.snapshot(null, null));
            ClipboardContent content = new ClipboardContent();
            content.putString(gate.getName());
            content.put((Object)DRAGGABLE_GATE, (Object)"");
            db.setContent((Map)content);
            e.consume();
        });
        this.setOnDragDone(e -> System.getProperties().remove(DRAGGABLE_GATE));
        this.setOnDragDropped(e -> System.out.println("Drag dropped"));
    }

    private String getStyle(String group) {
        return group.toLowerCase().replaceAll("_", "");
    }

    public Gate getGate() {
        return this.gate;
    }

    public boolean isMovable() {
        return this.movable;
    }

    private ContextMenu buildContextMenu() {
        ContextMenu menu = new ContextMenu();
        MenuItem mnRemove = new MenuItem("Remove");
        menu.setOnAction(e -> this.removeFromParent());
        menu.getItems().addAll((Object[])new MenuItem[]{mnRemove});
        return menu;
    }

    public void removeFromParent() {
        Pane parent = (Pane)this.getParent();
        if (parent != null) {
            parent.getChildren().remove((Object)this);
        }
    }
}

