/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.simulator.local;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.local.SimpleQuantumExecutionEnvironment;
import org.redfx.strange.simulator.CloudSimulator;
import org.redfx.strange.simulator.Model;
import org.redfx.strange.simulator.Simulator;

public class LocalSimulator
implements Simulator {
    private final int LOCAL_TRESHOLD = 1;
    private final Model model = Model.getInstance();
    CloudSimulator cloudSimulator = new CloudSimulator();

    public LocalSimulator() {
        this.model.refreshRequest().addListener((obs, oldv, newv) -> {
            this.calculate();
            this.model.refreshRequest().set(false);
        });
    }

    private void calculate() {
        int nq = this.model.getNQubits();
        Program p = new Program(nq, new Step[0]);
        int nsteps = this.model.getNumberOfSteps();
        for (int step = 0; step < nsteps; ++step) {
            Gate[] gate;
            Step s = new Step(new Gate[0]);
            for (Gate g : gate = this.model.getGatesByStep(step)) {
                s.addGate(g);
            }
            p.addStep(s);
            SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
            Result res = sqee.runProgram(p);
            Qubit[] qubits = res.getQubits();
            ArrayList<Double> probability = new ArrayList<Double>();
            for (Qubit qubit : qubits) {
                probability.add(qubit.getProbability());
            }
            ObservableList<Double> endStates = this.model.getEndStates();
            endStates.setAll(probability);
        }
    }

    @Override
    public Complex[] calculateResults(Gate[][] gates) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Complex[] calculateResults(Model m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] calculateQubitStates(Model m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

