/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.simulator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.redfx.strange.Gate;
import org.redfx.strange.gate.Identity;

public class Model {
    private int nqubits;
    private double[] beginState;
    private ObservableList<Double> endStates = FXCollections.observableArrayList();
    private BooleanProperty refreshRequest = new SimpleBooleanProperty();
    private static Model instance = new Model();
    private List<List<Gate>> gates = new LinkedList<List<Gate>>();

    private Model() {
    }

    public static Model getInstance() {
        return instance;
    }

    public BooleanProperty refreshRequest() {
        return this.refreshRequest;
    }

    public ObservableList<Double> getEndStates() {
        return this.endStates;
    }

    public void setNQubits(int n) {
        this.nqubits = n;
        this.beginState = new double[n];
        this.gates = new LinkedList<List<Gate>>();
        for (int i = 0; i < n; ++i) {
            this.gates.add(new LinkedList());
        }
    }

    public int getNQubits() {
        return this.nqubits;
    }

    public List<List<Gate>> getGates() {
        return this.gates;
    }

    public void setGatesForCircuit(int n, List<Gate> gates) {
    }

    public int getNumberOfSteps() {
        return this.gates.get(0).size();
    }

    public List<Gate> getStepsByCircuit(int idx) {
        return this.gates.get(idx);
    }

    public Gate[] getGatesByStep(int idx) {
        int nq = this.gates.size();
        Gate[] answer = new Gate[nq];
        for (int i = 0; i < nq; ++i) {
            if (this.gates.get(i).size() < idx + 1) {
                List<Gate> old = this.gates.get(i);
                ArrayList<Object> newList = new ArrayList<Object>();
                newList.addAll(old);
                newList.add(new Identity(i));
                this.gates.set(i, newList);
            }
            answer[i] = this.gates.get(i).get(idx);
        }
        return answer;
    }

    public String getGateDescription() {
        StringBuffer answer = new StringBuffer("[");
        int nq = this.getNQubits();
        for (int i = 0; i < this.getNumberOfSteps(); ++i) {
            answer.append("[");
            for (int j = 0; j < nq; ++j) {
                List<Gate> row = this.getGates().get(j);
                Identity target = new Identity(j);
                if (row.size() > i) {
                    target = row.get(i);
                }
                answer.append(target.getName());
                if (j >= nq - 1) continue;
                answer.append(",");
            }
            answer.append("]");
        }
        answer.append("]");
        return answer.toString();
    }

    public void printGates() {
        for (int i = 0; i < this.getNumberOfSteps(); ++i) {
            System.out.println("step " + i + ": " + this.getGatesByStep(i));
        }
    }
}

