// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Array32FW;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.HttpHeaderFW;

public final class HttpEndExFW extends Flyweight {
  public static final int FIELD_OFFSET_TYPE_ID = 0;

  private static final int FIELD_SIZE_TYPE_ID = 4;

  public static final int FIELD_OFFSET_TRAILERS = FIELD_OFFSET_TYPE_ID + FIELD_SIZE_TYPE_ID;

  private final Array32FW<HttpHeaderFW> trailersRO = new Array32FW<HttpHeaderFW>(new HttpHeaderFW());

  public int typeId() {
    return buffer().getInt(offset() + FIELD_OFFSET_TYPE_ID);
  }

  public Array32FW<HttpHeaderFW> trailers() {
    return trailersRO;
  }

  @Override
  public HttpEndExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    trailersRO.wrap(buffer, offset + FIELD_OFFSET_TRAILERS, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public HttpEndExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == trailersRO.tryWrap(buffer, offset + FIELD_OFFSET_TRAILERS, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return trailersRO.limit();
  }

  @Override
  public String toString() {
    return String.format("HTTP_END_EX [typeId=%d, trailers=%s]", typeId(), trailers());
  }

  public static final class Builder extends Flyweight.Builder<HttpEndExFW> {
    private static final int INDEX_TYPE_ID = 0;

    private static final int INDEX_TRAILERS = 1;

    private static final int FIELD_COUNT = 2;

    private final Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> trailersRW = new Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new HttpEndExFW());
    }

    public Builder typeId(int value) {
      assert lastFieldSet == INDEX_TYPE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_TYPE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_TYPE_ID;
      limit(newLimit);
      return this;
    }

    public Builder trailers(Consumer<Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
      assert lastFieldSet == INDEX_TRAILERS - 1;
      Array32FW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> trailersRW = this.trailersRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(trailersRW);
      limit(trailersRW.build().limit());
      lastFieldSet = INDEX_TRAILERS;
      return this;
    }

    public Builder trailers(Array32FW<HttpHeaderFW> field) {
      assert lastFieldSet == INDEX_TRAILERS - 1;
      int newLimit = limit() + field.sizeof();
      checkLimit(newLimit, maxLimit());
      buffer().putBytes(limit(), field.buffer(), field.offset(), field.sizeof());
      limit(newLimit);
      lastFieldSet = INDEX_TRAILERS;
      return this;
    }

    public Builder trailersItem(Consumer<HttpHeaderFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_TRAILERS - 1;
      if (lastFieldSet < INDEX_TRAILERS) {
        trailersRW.wrap(buffer(), limit(), maxLimit());
      }
      trailersRW.item(mutator);
      limit(trailersRW.build().limit());
      lastFieldSet = INDEX_TRAILERS;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
      super.wrap(array);
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public HttpEndExFW build() {
      if (lastFieldSet < INDEX_TRAILERS) {
        trailers(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
