// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.stream;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;

public final class FrameFW extends Flyweight {
  public static final int FIELD_OFFSET_ROUTE_ID = 0;

  private static final int FIELD_SIZE_ROUTE_ID = 8;

  public static final int FIELD_OFFSET_STREAM_ID = FIELD_OFFSET_ROUTE_ID + FIELD_SIZE_ROUTE_ID;

  private static final int FIELD_SIZE_STREAM_ID = 8;

  public static final int FIELD_OFFSET_SEQUENCE = FIELD_OFFSET_STREAM_ID + FIELD_SIZE_STREAM_ID;

  private static final int FIELD_SIZE_SEQUENCE = 8;

  public static final int FIELD_OFFSET_ACKNOWLEDGE = FIELD_OFFSET_SEQUENCE + FIELD_SIZE_SEQUENCE;

  private static final int FIELD_SIZE_ACKNOWLEDGE = 8;

  public static final int FIELD_OFFSET_MAXIMUM = FIELD_OFFSET_ACKNOWLEDGE + FIELD_SIZE_ACKNOWLEDGE;

  private static final int FIELD_SIZE_MAXIMUM = 4;

  public static final int FIELD_OFFSET_TIMESTAMP = FIELD_OFFSET_MAXIMUM + FIELD_SIZE_MAXIMUM;

  private static final int FIELD_SIZE_TIMESTAMP = 8;

  public static final int FIELD_OFFSET_TRACE_ID = FIELD_OFFSET_TIMESTAMP + FIELD_SIZE_TIMESTAMP;

  private static final int FIELD_SIZE_TRACE_ID = 8;

  public static final int FIELD_OFFSET_AUTHORIZATION = FIELD_OFFSET_TRACE_ID + FIELD_SIZE_TRACE_ID;

  private static final int FIELD_SIZE_AUTHORIZATION = 8;

  public long routeId() {
    return buffer().getLong(offset() + FIELD_OFFSET_ROUTE_ID);
  }

  public long streamId() {
    return buffer().getLong(offset() + FIELD_OFFSET_STREAM_ID);
  }

  public long sequence() {
    return buffer().getLong(offset() + FIELD_OFFSET_SEQUENCE);
  }

  public long acknowledge() {
    return buffer().getLong(offset() + FIELD_OFFSET_ACKNOWLEDGE);
  }

  public int maximum() {
    return buffer().getInt(offset() + FIELD_OFFSET_MAXIMUM);
  }

  public long timestamp() {
    return buffer().getLong(offset() + FIELD_OFFSET_TIMESTAMP);
  }

  public long traceId() {
    return buffer().getLong(offset() + FIELD_OFFSET_TRACE_ID);
  }

  public long authorization() {
    return buffer().getLong(offset() + FIELD_OFFSET_AUTHORIZATION);
  }

  @Override
  public FrameFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public FrameFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return offset() + FIELD_OFFSET_AUTHORIZATION + FIELD_SIZE_AUTHORIZATION;
  }

  @Override
  public String toString() {
    return String.format("FRAME [routeId=%d, streamId=%d, sequence=%d, acknowledge=%d, maximum=%d, timestamp=%d, traceId=%d, authorization=%d]", routeId(), streamId(), sequence(), acknowledge(), maximum(), timestamp(), traceId(), authorization());
  }

  public static final class Builder extends Flyweight.Builder<FrameFW> {
    private static final int INDEX_ROUTE_ID = 0;

    private static final int INDEX_STREAM_ID = 1;

    private static final int INDEX_SEQUENCE = 2;

    private static final int INDEX_ACKNOWLEDGE = 3;

    private static final int INDEX_MAXIMUM = 4;

    private static final int INDEX_TIMESTAMP = 5;

    public static final long DEFAULT_TIMESTAMP = 0;

    private static final int INDEX_TRACE_ID = 6;

    public static final long DEFAULT_TRACE_ID = 0;

    private static final int INDEX_AUTHORIZATION = 7;

    public static final long DEFAULT_AUTHORIZATION = 0;

    private static final int FIELD_COUNT = 8;

    private int lastFieldSet = -1;

    public Builder() {
      super(new FrameFW());
    }

    public Builder routeId(long value) {
      assert lastFieldSet == INDEX_ROUTE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_ROUTE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_ROUTE_ID;
      limit(newLimit);
      return this;
    }

    public Builder streamId(long value) {
      assert lastFieldSet == INDEX_STREAM_ID - 1;
      int newLimit = limit() + FIELD_SIZE_STREAM_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_STREAM_ID;
      limit(newLimit);
      return this;
    }

    public Builder sequence(long value) {
      assert lastFieldSet == INDEX_SEQUENCE - 1;
      int newLimit = limit() + FIELD_SIZE_SEQUENCE;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_SEQUENCE;
      limit(newLimit);
      return this;
    }

    public Builder acknowledge(long value) {
      assert lastFieldSet == INDEX_ACKNOWLEDGE - 1;
      int newLimit = limit() + FIELD_SIZE_ACKNOWLEDGE;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_ACKNOWLEDGE;
      limit(newLimit);
      return this;
    }

    public Builder maximum(int value) {
      assert lastFieldSet == INDEX_MAXIMUM - 1;
      int newLimit = limit() + FIELD_SIZE_MAXIMUM;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_MAXIMUM;
      limit(newLimit);
      return this;
    }

    public Builder timestamp(long value) {
      assert lastFieldSet == INDEX_TIMESTAMP - 1;
      int newLimit = limit() + FIELD_SIZE_TIMESTAMP;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_TIMESTAMP;
      limit(newLimit);
      return this;
    }

    public Builder traceId(long value) {
      if (lastFieldSet < INDEX_TIMESTAMP) {
        timestamp(DEFAULT_TIMESTAMP);
      }
      assert lastFieldSet == INDEX_TRACE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_TRACE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_TRACE_ID;
      limit(newLimit);
      return this;
    }

    public Builder authorization(long value) {
      if (lastFieldSet < INDEX_TRACE_ID) {
        traceId(DEFAULT_TRACE_ID);
      }
      assert lastFieldSet == INDEX_AUTHORIZATION - 1;
      int newLimit = limit() + FIELD_SIZE_AUTHORIZATION;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_AUTHORIZATION;
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
      super.wrap(array);
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public FrameFW build() {
      if (lastFieldSet < INDEX_AUTHORIZATION) {
        authorization(DEFAULT_AUTHORIZATION);
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
