// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.state;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Array32FW;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;

public final class RouteTableFW extends Flyweight {
  public static final int FIELD_OFFSET_MODIFICATION_COUNT = 0;

  private static final int FIELD_SIZE_MODIFICATION_COUNT = 4;

  public static final int FIELD_OFFSET_ENTRIES = FIELD_OFFSET_MODIFICATION_COUNT + FIELD_SIZE_MODIFICATION_COUNT;

  private final Array32FW<RouteEntryFW> entriesRO = new Array32FW<RouteEntryFW>(new RouteEntryFW());

  public int modificationCount() {
    return buffer().getInt(offset() + FIELD_OFFSET_MODIFICATION_COUNT);
  }

  public Array32FW<RouteEntryFW> entries() {
    return entriesRO;
  }

  @Override
  public RouteTableFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    entriesRO.wrap(buffer, offset + FIELD_OFFSET_ENTRIES, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public RouteTableFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == entriesRO.tryWrap(buffer, offset + FIELD_OFFSET_ENTRIES, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return entriesRO.limit();
  }

  @Override
  public String toString() {
    return String.format("ROUTE_TABLE [modificationCount=%d, entries=%s]", modificationCount(), entries());
  }

  public static final class Builder extends Flyweight.Builder<RouteTableFW> {
    private static final int INDEX_MODIFICATION_COUNT = 0;

    private static final int INDEX_ENTRIES = 1;

    private static final int FIELD_COUNT = 2;

    private final Array32FW.Builder<RouteEntryFW.Builder, RouteEntryFW> entriesRW = new Array32FW.Builder<RouteEntryFW.Builder, RouteEntryFW>(new RouteEntryFW.Builder(), new RouteEntryFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new RouteTableFW());
    }

    public Builder modificationCount(int value) {
      assert lastFieldSet == INDEX_MODIFICATION_COUNT - 1;
      int newLimit = limit() + FIELD_SIZE_MODIFICATION_COUNT;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_MODIFICATION_COUNT;
      limit(newLimit);
      return this;
    }

    public Builder entries(Consumer<Array32FW.Builder<RouteEntryFW.Builder, RouteEntryFW>> mutator) {
      assert lastFieldSet == INDEX_ENTRIES - 1;
      Array32FW.Builder<RouteEntryFW.Builder, RouteEntryFW> entriesRW = this.entriesRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(entriesRW);
      limit(entriesRW.build().limit());
      lastFieldSet = INDEX_ENTRIES;
      return this;
    }

    public Builder entries(Array32FW<RouteEntryFW> field) {
      assert lastFieldSet == INDEX_ENTRIES - 1;
      int newLimit = limit() + field.sizeof();
      checkLimit(newLimit, maxLimit());
      buffer().putBytes(limit(), field.buffer(), field.offset(), field.sizeof());
      limit(newLimit);
      lastFieldSet = INDEX_ENTRIES;
      return this;
    }

    public Builder entriesItem(Consumer<RouteEntryFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_ENTRIES - 1;
      if (lastFieldSet < INDEX_ENTRIES) {
        entriesRW.wrap(buffer(), limit(), maxLimit());
      }
      entriesRW.item(mutator);
      limit(entriesRW.build().limit());
      lastFieldSet = INDEX_ENTRIES;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
      super.wrap(array);
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public RouteTableFW build() {
      if (lastFieldSet < INDEX_ENTRIES) {
        entries(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
