// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.state;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;

public final class RouteEntryFW extends Flyweight {
  public static final int FIELD_OFFSET_LENGTH = 0;

  private static final int FIELD_SIZE_LENGTH = 4;

  public static final int FIELD_OFFSET_ROUTE = FIELD_OFFSET_LENGTH + FIELD_SIZE_LENGTH;

  private final OctetsFW routeRO = new OctetsFW();

  public long length() {
    return (long)(buffer().getInt(offset() + FIELD_OFFSET_LENGTH) & 0xFFFF_FFFFL);
  }

  public OctetsFW route() {
    return routeRO;
  }

  @Override
  public RouteEntryFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    routeRO.wrap(buffer, offset + FIELD_OFFSET_ROUTE, offset + FIELD_OFFSET_ROUTE + (int) length());
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public RouteEntryFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    int limit;
    limit = offset + FIELD_OFFSET_ROUTE + (int) length();
    if (limit > maxLimit || null == routeRO.tryWrap(buffer, offset + FIELD_OFFSET_ROUTE, limit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return routeRO.limit();
  }

  @Override
  public String toString() {
    return String.format("ROUTE_ENTRY [length=%d, route=%s]", length(), route());
  }

  public static final class Builder extends Flyweight.Builder<RouteEntryFW> {
    public static final long DEFAULT_LENGTH = 0;

    private static final int INDEX_ROUTE = 0;

    private static final int FIELD_COUNT = 1;

    private int dynamicOffsetLength;

    private final OctetsFW.Builder routeRW = new OctetsFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new RouteEntryFW());
    }

    private Builder length(long value) {
      if (value < 0) {
        throw new IllegalArgumentException(String.format("Value %d too low for field \"length\"", value));
      }
      if (value > 0xFFFFFFFFL) {
        throw new IllegalArgumentException(String.format("Value %d too high for field \"length\"", value));
      }
      int newLimit = limit() + FIELD_SIZE_LENGTH;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), (int)(value & 0xFFFF_FFFFL));
      dynamicOffsetLength = limit();
      limit(newLimit);
      return this;
    }

    private OctetsFW.Builder route() {
      length(DEFAULT_LENGTH);
      assert lastFieldSet == INDEX_ROUTE - 1;
      return routeRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder route(OctetsFW value) {
      int size$;
      int newLimit;
      OctetsFW.Builder routeRW = route();
      if (value == null) {
        throw new IllegalArgumentException("value cannot be null for field \"route\" that does not default to null");
      }
      routeRW.set(value);
      newLimit = routeRW.build().limit();
      size$ = newLimit - limit();
      limit(dynamicOffsetLength);
      length(size$);
      limit(newLimit);
      lastFieldSet = INDEX_ROUTE;
      return this;
    }

    public Builder route(Consumer<OctetsFW.Builder> mutator) {
      OctetsFW.Builder routeRW = route();
      mutator.accept(routeRW);
      int newLimit = routeRW.build().limit();
      int size$ = newLimit - limit();
      limit(dynamicOffsetLength);
      length(size$);
      limit(newLimit);
      lastFieldSet = INDEX_ROUTE;
      return this;
    }

    public Builder route(DirectBuffer buffer, int offset, int length) {
      OctetsFW.Builder routeRW = route();
      routeRW.set(buffer, offset, length);
      int newLimit = routeRW.build().limit();
      int size$ = newLimit - limit();
      limit(dynamicOffsetLength);
      length(size$);
      limit(newLimit);
      lastFieldSet = INDEX_ROUTE;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      dynamicOffsetLength = -1;
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<?, ?, ?> array) {
      super.wrap(array);
      dynamicOffsetLength = -1;
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public RouteEntryFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
