// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.control;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;

public final class CapabilityFW extends Flyweight {
  private static final int FIELD_OFFSET_VALUE = 0;

  private static final int FIELD_SIZE_VALUE = BitUtil.SIZE_OF_BYTE;

  @Override
  public int limit() {
    return offset() + FIELD_SIZE_VALUE;
  }

  public Capability get() {
    return Capability.valueOf(buffer().getByte(offset() + FIELD_OFFSET_VALUE));
  }

  @Override
  public CapabilityFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (super.tryWrap(buffer, offset, maxLimit) == null || limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public CapabilityFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public String toString() {
    return maxLimit() == offset() ? "null" : get().toString();
  }

  public static final class Builder extends Flyweight.Builder<CapabilityFW> {
    private boolean valueSet;

    public Builder() {
      super(new CapabilityFW());
    }

    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      return this;
    }

    public Builder set(CapabilityFW value) {
      int newLimit = offset() + value.sizeof();
      checkLimit(newLimit, maxLimit());
      buffer().putBytes(offset(), value.buffer(), value.offset(), value.sizeof());
      limit(newLimit);
      valueSet = true;
      return this;
    }

    public Builder set(Capability value) {
      MutableDirectBuffer buffer = buffer();
      int offset = offset();
      int newLimit = offset + FIELD_SIZE_VALUE;
      checkLimit(newLimit, maxLimit());
      buffer.putByte(offset, (byte) value.ordinal());
      limit(newLimit);
      valueSet = true;
      return this;
    }

    @Override
    public CapabilityFW build() {
      if (!valueSet) {
        throw new IllegalStateException("Capability not set");
      }
      return super.build();
    }
  }
}
