// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import java.nio.charset.Charset;
import org.agrona.DirectBuffer;

public abstract class StringFW extends Flyweight {
  public abstract int fieldSizeLength();

  public abstract String asString();

  public abstract int length();

  public abstract static class Builder<T extends StringFW> extends Flyweight.Builder<T> {
    public Builder(T flyweight) {
      super(flyweight);
    }

    public abstract Builder<T> set(StringFW value);

    public abstract Builder<T> set(DirectBuffer srcBuffer, int srcOffset, int length);

    public abstract Builder<T> set(String value, Charset charset);
  }
}
