// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class List8FW extends ListFW {
  private static final int LENGTH_SIZE = BitUtil.SIZE_OF_BYTE;

  private static final int FIELD_COUNT_SIZE = BitUtil.SIZE_OF_BYTE;

  private static final int LENGTH_OFFSET = 0;

  private static final int FIELD_COUNT_OFFSET = LENGTH_OFFSET + LENGTH_SIZE;

  private static final int FIELDS_OFFSET = FIELD_COUNT_OFFSET + FIELD_COUNT_SIZE;

  private static final int LENGTH_MAX_VALUE = 0xFF;

  private final DirectBuffer fieldsRO = new UnsafeBuffer(0L, 0);

  @Override
  public int limit() {
    return offset() + LENGTH_SIZE + length();
  }

  @Override
  public int length() {
    return buffer().getByte(offset() + LENGTH_OFFSET) & 0xFF;
  }

  @Override
  public int fieldCount() {
    return buffer().getByte(offset() + FIELD_COUNT_OFFSET) & 0xFF;
  }

  @Override
  public DirectBuffer fields() {
    return fieldsRO;
  }

  @Override
  public List8FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (super.tryWrap(buffer, offset, maxLimit) == null) {
      return null;
    }
    final int fieldsSize = length() - FIELD_COUNT_SIZE;
    fieldsRO.wrap(buffer, offset + FIELDS_OFFSET, fieldsSize);
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public List8FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    final int fieldsSize = length() - FIELD_COUNT_SIZE;
    fieldsRO.wrap(buffer, offset + FIELDS_OFFSET, fieldsSize);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public String toString() {
    return String.format("list8<%d, %d>", length(), fieldCount());
  }

  public static final class Builder extends ListFW.Builder<List8FW> {
    private int fieldCount;

    public Builder() {
      super(new List8FW());
    }

    @Override
    public Builder field(Flyweight.Builder.Visitor visitor) {
      int length = visitor.visit(buffer(), limit(), maxLimit());
      fieldCount++;
      int newLimit = limit() + length;
      checkLimit(newLimit, maxLimit());
      limit(newLimit);
      return this;
    }

    @Override
    public Builder fields(int fieldCount, Flyweight.Builder.Visitor visitor) {
      int length = visitor.visit(buffer(), limit(), maxLimit());
      this.fieldCount += fieldCount;
      int newLimit = limit() + length;
      checkLimit(newLimit, maxLimit());
      limit(newLimit);
      return this;
    }

    @Override
    public Builder fields(int fieldCount, DirectBuffer buffer, int index, int length) {
      this.fieldCount += fieldCount;
      int newLimit = limit() + length;
      checkLimit(newLimit, maxLimit());
      buffer().putBytes(limit(), buffer, index, length);
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      int newLimit = offset + FIELDS_OFFSET;
      checkLimit(newLimit, maxLimit);
      limit(newLimit);
      this.fieldCount = 0;
      return this;
    }

    @Override
    public List8FW build() {
      int length = limit() - offset() - FIELD_COUNT_OFFSET;
      assert length <= LENGTH_MAX_VALUE : "Length is too large";
      assert fieldCount <= LENGTH_MAX_VALUE : "Field count is too large";
      buffer().putByte(offset() + LENGTH_OFFSET, (byte) length);
      buffer().putByte(offset() + FIELD_COUNT_OFFSET, (byte) fieldCount);
      return super.build();
    }
  }
}
