// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class List0FW extends ListFW {
  private static final DirectBuffer FIELDS_EMPTY_VALUE = new UnsafeBuffer(0L, 0);

  private static final int LENGTH_SIZE = 0;

  private static final int LENGTH_VALUE = 0;

  private static final int FIELD_COUNT_VALUE = 0;

  @Override
  public int limit() {
    return offset() + LENGTH_SIZE + length();
  }

  @Override
  public int length() {
    return LENGTH_VALUE;
  }

  @Override
  public int fieldCount() {
    return FIELD_COUNT_VALUE;
  }

  @Override
  public DirectBuffer fields() {
    return FIELDS_EMPTY_VALUE;
  }

  @Override
  public List0FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (super.tryWrap(buffer, offset, maxLimit) == null) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public List0FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public String toString() {
    return String.format("list0<%d, %d>", length(), fieldCount());
  }

  public static final class Builder extends ListFW.Builder<List0FW> {
    public Builder() {
      super(new List0FW());
    }

    @Override
    public Builder field(Flyweight.Builder.Visitor visitor) {
      throw new UnsupportedOperationException();
    }

    @Override
    public Builder fields(int fieldCount, Flyweight.Builder.Visitor visitor) {
      assert fieldCount == 0;
      return this;
    }

    @Override
    public Builder fields(int fieldCount, DirectBuffer buffer, int index, int length) {
      assert fieldCount == 0;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      checkLimit(limit(), maxLimit);
      return this;
    }

    @Override
    public List0FW build() {
      return super.build();
    }
  }
}
