// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class BoundedOctets8FW extends BoundedOctetsFW {
  private static final int LENGTH_SIZE = BitUtil.SIZE_OF_BYTE;

  private static final int LENGTH_OFFSET = 0;

  private static final int VALUE_OFFSET = LENGTH_OFFSET + LENGTH_SIZE;

  private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

  @Override
  public <T> T get(Flyweight.Visitor<T> visitor) {
    return visitor.visit(buffer(), offset() + VALUE_OFFSET, limit());
  }

  @Override
  public DirectBuffer value() {
    return valueRO;
  }

  @Override
  public int length() {
    return buffer().getByte(offset() + LENGTH_OFFSET) & 0xFF;
  }

  @Override
  public BoundedOctets8FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (super.tryWrap(buffer, offset, maxLimit) == null) {
      return null;
    }
    valueRO.wrap(buffer, offset + VALUE_OFFSET, length());
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public BoundedOctets8FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    valueRO.wrap(buffer, offset + VALUE_OFFSET, length());
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public int limit() {
    return offset() + LENGTH_SIZE + length();
  }

  @Override
  public String toString() {
    return String.format("boundedOctets8[%d]", length());
  }

  public static final class Builder extends BoundedOctetsFW.Builder<BoundedOctets8FW> {
    public Builder() {
      super(new BoundedOctets8FW());
    }

    @Override
    public Builder set(BoundedOctetsFW value) {
      int newLimit = offset() + LENGTH_SIZE + value.length();
      checkLimit(newLimit, maxLimit());
      buffer().putByte(offset() + LENGTH_OFFSET, (byte) (value.length() & 0xFF));
      buffer().putBytes(offset() + VALUE_OFFSET, value.buffer(), value.offset() + VALUE_OFFSET, value.length());
      limit(newLimit);
      return this;
    }

    @Override
    public Builder set(DirectBuffer value, int offset, int length) {
      int newLimit = offset() + LENGTH_SIZE + length;
      checkLimit(newLimit, maxLimit());
      buffer().putByte(offset() + LENGTH_OFFSET, (byte) (length & 0xFF));
      buffer().putBytes(offset() + VALUE_OFFSET, value, offset, length);
      limit(newLimit);
      return this;
    }

    @Override
    public Builder set(byte[] value) {
      int newLimit = offset() + LENGTH_SIZE + value.length;
      checkLimit(newLimit, maxLimit());
      buffer().putByte(offset() + LENGTH_OFFSET, (byte) (value.length & 0xFF));
      buffer().putBytes(offset() + VALUE_OFFSET, value);
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      checkLimit(offset + LENGTH_SIZE, maxLimit);
      super.wrap(buffer, offset, maxLimit);
      return this;
    }
  }
}
