// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;

public final class ChallengeFW extends Flyweight {
  public static final int FIELD_OFFSET_ROUTE_ID = 0;

  private static final int FIELD_SIZE_ROUTE_ID = 8;

  public static final int FIELD_OFFSET_STREAM_ID = FIELD_OFFSET_ROUTE_ID + FIELD_SIZE_ROUTE_ID;

  private static final int FIELD_SIZE_STREAM_ID = 8;

  public static final int FIELD_OFFSET_TIMESTAMP = FIELD_OFFSET_STREAM_ID + FIELD_SIZE_STREAM_ID;

  private static final int FIELD_SIZE_TIMESTAMP = 8;

  public static final int FIELD_OFFSET_TRACE_ID = FIELD_OFFSET_TIMESTAMP + FIELD_SIZE_TIMESTAMP;

  private static final int FIELD_SIZE_TRACE_ID = 8;

  public static final int FIELD_OFFSET_AUTHORIZATION = FIELD_OFFSET_TRACE_ID + FIELD_SIZE_TRACE_ID;

  private static final int FIELD_SIZE_AUTHORIZATION = 8;

  public static final int FIELD_OFFSET_EXTENSION = FIELD_OFFSET_AUTHORIZATION + FIELD_SIZE_AUTHORIZATION;

  public static final int TYPE_ID = 0x40000004;

  private final OctetsFW extensionRO = new OctetsFW();

  public long routeId() {
    return buffer().getLong(offset() + FIELD_OFFSET_ROUTE_ID);
  }

  public long streamId() {
    return buffer().getLong(offset() + FIELD_OFFSET_STREAM_ID);
  }

  public long timestamp() {
    return buffer().getLong(offset() + FIELD_OFFSET_TIMESTAMP);
  }

  public long traceId() {
    return buffer().getLong(offset() + FIELD_OFFSET_TRACE_ID);
  }

  public long authorization() {
    return buffer().getLong(offset() + FIELD_OFFSET_AUTHORIZATION);
  }

  public OctetsFW extension() {
    return extensionRO;
  }

  public int typeId() {
    return TYPE_ID;
  }

  @Override
  public ChallengeFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    extensionRO.wrap(buffer, offset + FIELD_OFFSET_EXTENSION, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public ChallengeFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == extensionRO.tryWrap(buffer, offset + FIELD_OFFSET_EXTENSION, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return extensionRO.limit();
  }

  @Override
  public String toString() {
    return String.format("CHALLENGE [routeId=%d, streamId=%d, timestamp=%d, traceId=%d, authorization=%d, extension=%s]", routeId(), streamId(), timestamp(), traceId(), authorization(), extension());
  }

  public static final class Builder extends Flyweight.Builder<ChallengeFW> {
    private static final int INDEX_ROUTE_ID = 0;

    private static final int INDEX_STREAM_ID = 1;

    private static final int INDEX_TIMESTAMP = 2;

    private static final long DEFAULT_TIMESTAMP = 0;

    private static final int INDEX_TRACE_ID = 3;

    private static final long DEFAULT_TRACE_ID = 0;

    private static final int INDEX_AUTHORIZATION = 4;

    private static final long DEFAULT_AUTHORIZATION = 0;

    private static final int INDEX_EXTENSION = 5;

    private static final int FIELD_COUNT = 6;

    private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new ChallengeFW());
    }

    public Builder routeId(long value) {
      assert lastFieldSet == INDEX_ROUTE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_ROUTE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_ROUTE_ID;
      limit(newLimit);
      return this;
    }

    public Builder streamId(long value) {
      assert lastFieldSet == INDEX_STREAM_ID - 1;
      int newLimit = limit() + FIELD_SIZE_STREAM_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_STREAM_ID;
      limit(newLimit);
      return this;
    }

    public Builder timestamp(long value) {
      assert lastFieldSet == INDEX_TIMESTAMP - 1;
      int newLimit = limit() + FIELD_SIZE_TIMESTAMP;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_TIMESTAMP;
      limit(newLimit);
      return this;
    }

    public Builder traceId(long value) {
      if (lastFieldSet < INDEX_TIMESTAMP) {
        timestamp(DEFAULT_TIMESTAMP);
      }
      assert lastFieldSet == INDEX_TRACE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_TRACE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_TRACE_ID;
      limit(newLimit);
      return this;
    }

    public Builder authorization(long value) {
      if (lastFieldSet < INDEX_TRACE_ID) {
        traceId(DEFAULT_TRACE_ID);
      }
      assert lastFieldSet == INDEX_AUTHORIZATION - 1;
      int newLimit = limit() + FIELD_SIZE_AUTHORIZATION;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_AUTHORIZATION;
      limit(newLimit);
      return this;
    }

    private OctetsFW.Builder extension() {
      if (lastFieldSet < INDEX_AUTHORIZATION) {
        authorization(DEFAULT_AUTHORIZATION);
      }
      assert lastFieldSet == INDEX_EXTENSION - 1;
      return extensionRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder extension(OctetsFW value) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(value);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(Consumer<OctetsFW.Builder> mutator) {
      OctetsFW.Builder extensionRW = extension();
      mutator.accept(extensionRW);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(DirectBuffer buffer, int offset, int length) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(buffer, offset, length);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<? extends ArrayFW<ChallengeFW>, ? extends Flyweight.Builder<ChallengeFW>, ChallengeFW> array) {
      super.wrap(array);
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public ChallengeFW build() {
      if (lastFieldSet < INDEX_EXTENSION) {
        extension(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
