// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.control;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;

public final class ResponseFW extends Flyweight {
  public static final int FIELD_OFFSET_CORRELATION_ID = 0;

  private static final int FIELD_SIZE_CORRELATION_ID = 8;

  public long correlationId() {
    return buffer().getLong(offset() + FIELD_OFFSET_CORRELATION_ID);
  }

  @Override
  public ResponseFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public ResponseFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return offset() + FIELD_OFFSET_CORRELATION_ID + FIELD_SIZE_CORRELATION_ID;
  }

  @Override
  public String toString() {
    return String.format("RESPONSE [correlationId=%d]", correlationId());
  }

  public static final class Builder extends Flyweight.Builder<ResponseFW> {
    private static final int INDEX_CORRELATION_ID = 0;

    private static final int FIELD_COUNT = 1;

    private int lastFieldSet = -1;

    public Builder() {
      super(new ResponseFW());
    }

    public Builder correlationId(long value) {
      assert lastFieldSet == INDEX_CORRELATION_ID - 1;
      int newLimit = limit() + FIELD_SIZE_CORRELATION_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_CORRELATION_ID;
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<? extends ArrayFW<ResponseFW>, ? extends Flyweight.Builder<ResponseFW>, ResponseFW> array) {
      super.wrap(array);
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public ResponseFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
