// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Array32FW;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.OctetsFW;
import org.reaktivity.nukleus.oauth.internal.types.String8FW;

public final class ResolveFW extends Flyweight {
  public static final int FIELD_OFFSET_CORRELATION_ID = 0;

  private static final int FIELD_SIZE_CORRELATION_ID = 8;

  public static final int FIELD_OFFSET_NUKLEUS = FIELD_OFFSET_CORRELATION_ID + FIELD_SIZE_CORRELATION_ID;

  public static final int FIELD_OFFSET_REALM = 0;

  public static final int FIELD_OFFSET_ROLES = 0;

  public static final int FIELD_OFFSET_EXTENSION = 0;

  public static final int TYPE_ID = 0x00000011;

  private final String8FW nukleusRO = new String8FW();

  private final String8FW realmRO = new String8FW();

  private final Array32FW<String8FW> rolesRO = new Array32FW<String8FW>(new String8FW());

  private final OctetsFW extensionRO = new OctetsFW();

  public long correlationId() {
    return buffer().getLong(offset() + FIELD_OFFSET_CORRELATION_ID);
  }

  public String8FW nukleus() {
    return nukleusRO;
  }

  public String8FW realm() {
    return realmRO;
  }

  public Array32FW<String8FW> roles() {
    return rolesRO;
  }

  public OctetsFW extension() {
    return extensionRO;
  }

  public int typeId() {
    return TYPE_ID;
  }

  @Override
  public ResolveFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    nukleusRO.wrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit);
    realmRO.wrap(buffer, nukleusRO.limit() + FIELD_OFFSET_REALM, maxLimit);
    rolesRO.wrap(buffer, realmRO.limit() + FIELD_OFFSET_ROLES, maxLimit);
    extensionRO.wrap(buffer, rolesRO.limit() + FIELD_OFFSET_EXTENSION, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public ResolveFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == nukleusRO.tryWrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit)) {
      return null;
    }
    if (null == realmRO.tryWrap(buffer, nukleusRO.limit() + FIELD_OFFSET_REALM, maxLimit)) {
      return null;
    }
    if (null == rolesRO.tryWrap(buffer, realmRO.limit() + FIELD_OFFSET_ROLES, maxLimit)) {
      return null;
    }
    if (null == extensionRO.tryWrap(buffer, rolesRO.limit() + FIELD_OFFSET_EXTENSION, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return extensionRO.limit();
  }

  @Override
  public String toString() {
    return String.format("RESOLVE [correlationId=%d, nukleus=%s, realm=%s, roles=%s, extension=%s]", correlationId(), nukleusRO.asString(), realmRO.asString(), roles(), extension());
  }

  public static final class Builder extends Flyweight.Builder<ResolveFW> {
    private static final int INDEX_CORRELATION_ID = 0;

    private static final int INDEX_NUKLEUS = 1;

    private static final int INDEX_REALM = 2;

    private static final int INDEX_ROLES = 3;

    private static final int INDEX_EXTENSION = 4;

    private static final int FIELD_COUNT = 5;

    private final String8FW.Builder nukleusRW = new String8FW.Builder();

    private final String8FW.Builder realmRW = new String8FW.Builder();

    private final Array32FW.Builder<String8FW.Builder, String8FW> rolesRW = new Array32FW.Builder<String8FW.Builder, String8FW>(new String8FW.Builder(), new String8FW());

    private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new ResolveFW());
    }

    public Builder correlationId(long value) {
      assert lastFieldSet == INDEX_CORRELATION_ID - 1;
      int newLimit = limit() + FIELD_SIZE_CORRELATION_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_CORRELATION_ID;
      limit(newLimit);
      return this;
    }

    private String8FW.Builder nukleus() {
      assert lastFieldSet == INDEX_NUKLEUS - 1;
      return nukleusRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder nukleus(String value) {
      String8FW.Builder nukleusRW = nukleus();
      nukleusRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(String8FW value) {
      String8FW.Builder nukleusRW = nukleus();
      nukleusRW.set(value);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(DirectBuffer buffer, int offset, int length) {
      String8FW.Builder nukleusRW = nukleus();
      nukleusRW.set(buffer, offset, length);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    private String8FW.Builder realm() {
      assert lastFieldSet == INDEX_REALM - 1;
      return realmRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder realm(String value) {
      String8FW.Builder realmRW = realm();
      realmRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_REALM;
      limit(realmRW.build().limit());
      return this;
    }

    public Builder realm(String8FW value) {
      String8FW.Builder realmRW = realm();
      realmRW.set(value);
      lastFieldSet = INDEX_REALM;
      limit(realmRW.build().limit());
      return this;
    }

    public Builder realm(DirectBuffer buffer, int offset, int length) {
      String8FW.Builder realmRW = realm();
      realmRW.set(buffer, offset, length);
      lastFieldSet = INDEX_REALM;
      limit(realmRW.build().limit());
      return this;
    }

    public Builder roles(Consumer<Array32FW.Builder<String8FW.Builder, String8FW>> mutator) {
      assert lastFieldSet == INDEX_ROLES - 1;
      Array32FW.Builder<String8FW.Builder, String8FW> rolesRW = this.rolesRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(rolesRW);
      limit(rolesRW.build().limit());
      lastFieldSet = INDEX_ROLES;
      return this;
    }

    public Builder rolesItem(Consumer<String8FW.Builder> mutator) {
      assert lastFieldSet >= INDEX_ROLES - 1;
      if (lastFieldSet < INDEX_ROLES) {
        rolesRW.wrap(buffer(), limit(), maxLimit());
      }
      rolesRW.item(mutator);
      limit(rolesRW.build().limit());
      lastFieldSet = INDEX_ROLES;
      return this;
    }

    private OctetsFW.Builder extension() {
      if (lastFieldSet < INDEX_ROLES) {
        roles(b -> { });
      }
      assert lastFieldSet == INDEX_EXTENSION - 1;
      return extensionRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder extension(OctetsFW value) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(value);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(Consumer<OctetsFW.Builder> mutator) {
      OctetsFW.Builder extensionRW = extension();
      mutator.accept(extensionRW);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    public Builder extension(DirectBuffer buffer, int offset, int length) {
      OctetsFW.Builder extensionRW = extension();
      extensionRW.set(buffer, offset, length);
      limit(extensionRW.build().limit());
      lastFieldSet = INDEX_EXTENSION;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<? extends ArrayFW<ResolveFW>, ? extends Flyweight.Builder<ResolveFW>, ResolveFW> array) {
      super.wrap(array);
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public ResolveFW build() {
      if (lastFieldSet < INDEX_EXTENSION) {
        extension(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
