// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.String8FW;

public final class CommandFW extends Flyweight {
  public static final int FIELD_OFFSET_CORRELATION_ID = 0;

  private static final int FIELD_SIZE_CORRELATION_ID = 8;

  public static final int FIELD_OFFSET_NUKLEUS = FIELD_OFFSET_CORRELATION_ID + FIELD_SIZE_CORRELATION_ID;

  private final String8FW nukleusRO = new String8FW();

  public long correlationId() {
    return buffer().getLong(offset() + FIELD_OFFSET_CORRELATION_ID);
  }

  public String8FW nukleus() {
    return nukleusRO;
  }

  @Override
  public CommandFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    nukleusRO.wrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public CommandFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == nukleusRO.tryWrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return nukleusRO.limit();
  }

  @Override
  public String toString() {
    return String.format("COMMAND [correlationId=%d, nukleus=%s]", correlationId(), nukleusRO.asString());
  }

  public static final class Builder extends Flyweight.Builder<CommandFW> {
    private static final int INDEX_CORRELATION_ID = 0;

    private static final int INDEX_NUKLEUS = 1;

    private static final int FIELD_COUNT = 2;

    private final String8FW.Builder nukleusRW = new String8FW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new CommandFW());
    }

    public Builder correlationId(long value) {
      assert lastFieldSet == INDEX_CORRELATION_ID - 1;
      int newLimit = limit() + FIELD_SIZE_CORRELATION_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_CORRELATION_ID;
      limit(newLimit);
      return this;
    }

    private String8FW.Builder nukleus() {
      assert lastFieldSet == INDEX_NUKLEUS - 1;
      return nukleusRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder nukleus(String value) {
      String8FW.Builder nukleusRW = nukleus();
      nukleusRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(String8FW value) {
      String8FW.Builder nukleusRW = nukleus();
      nukleusRW.set(value);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(DirectBuffer buffer, int offset, int length) {
      String8FW.Builder nukleusRW = nukleus();
      nukleusRW.set(buffer, offset, length);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      limit(offset);
      return this;
    }

    @Override
    public Builder wrap(ArrayFW.Builder<? extends ArrayFW<CommandFW>, ? extends Flyweight.Builder<CommandFW>, CommandFW> array) {
      super.wrap(array);
      lastFieldSet = -1;
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public CommandFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
