// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class Varbyteuint32FW extends Flyweight {
  private int size;

  @Override
  public int limit() {
    return offset() + size;
  }

  public int value() {
    final DirectBuffer buffer = buffer();
    final int offset = offset();
    final int limit = limit();
    int value = 0;
    int index = 0;
    int multiplier = 1;
    int b;
    do {
      b = buffer.getByte(offset + index);
      value += (b & 0x7F) * multiplier;
      multiplier *= 0x80;
      index++;
    } while (offset + index < limit && (b & 0x80) != 0);
    return value;
  }

  @Override
  public Varbyteuint32FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit) || maxLimit - offset < 1) {
      return null;
    }
    size = length0();
    if (size < 0 || size > 5 || limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public Varbyteuint32FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    checkLimit(offset + 1, maxLimit);
    size = length0();
    if (size < 0 || size > 5) {
      throw new IllegalArgumentException(String.format("varbyteuint32 value at offset %d exceeds 32 bits", offset));
    }
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public String toString() {
    return Integer.toString(value());
  }

  private int length0() {
    final DirectBuffer buffer = buffer();
    final int offset = offset();
    final int maxPos = Math.min(offset + 5,  maxLimit());
    int index = 0;
    while (index + offset < maxPos && (buffer.getByte(index + offset) & 0x80) != 0) {
      index++;
    }
    int size = 1 + index;
    return size;
  }

  public static final class Builder extends Flyweight.Builder<Varbyteuint32FW> {
    private boolean valueSet;

    public Builder() {
      super(new Varbyteuint32FW());
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      checkLimit(offset + 1, maxLimit);
      super.wrap(buffer, offset, maxLimit);
      this.valueSet = false;
      return this;
    }

    public Builder set(int value) {
      if (value > 0x0FFFFFFF) {
        throw new IllegalArgumentException(String.format("Input value %d too long", value));
      }
      final MutableDirectBuffer buffer = buffer();
      int progress = offset();
      int varint = 0;
      int i = 0;
      do {
        int encodedByte = value % 0x80;
        value /= 0x80;
        if (value > 0) {
          encodedByte |= 0x80;
        }
        varint |= ((varint & 0x80) > 0 ? encodedByte << (8 * i) : encodedByte) | varint;
        buffer.putByte(progress++, (byte) (encodedByte & 0xFF));
        i++;
      } while (value > 0);
      int newLimit = progress;
      checkLimit(newLimit, maxLimit());
      limit(newLimit);
      valueSet = true;
      return this;
    }

    @Override
    public Varbyteuint32FW build() {
      if (!valueSet) {
        throw new IllegalArgumentException("value not set");
      }
      return super.build();
    }
  }
}
