// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;

public abstract class MapFW<K extends Flyweight, V extends Flyweight> extends Flyweight {
  public abstract int length();

  public abstract int fieldCount();

  public abstract void forEach(Function<K, Consumer<V>> consumer);

  public abstract DirectBuffer entries();

  public abstract static class Builder<T extends MapFW, K extends Flyweight, V extends Flyweight, KB extends Flyweight.Builder<K>, VB extends Flyweight.Builder<V>> extends Flyweight.Builder<T> {
    public Builder(T flyweight) {
      super(flyweight);
    }

    public abstract Builder<T, K, V, KB, VB> entry(Consumer<KB> key, Consumer<VB> value);

    public abstract Builder<T, K, V, KB, VB> entries(DirectBuffer buffer, int srcOffset, int length,
        int fieldCount);
  }
}
