// TODO: license
package org.reaktivity.nukleus.oauth.internal.types;

import org.agrona.DirectBuffer;

public abstract class ListFW extends Flyweight {
  public abstract int length();

  public abstract int fieldCount();

  public abstract DirectBuffer fields();

  public abstract static class Builder<T extends ListFW> extends Flyweight.Builder<T> {
    private int fieldCount;

    public Builder(T flyweight) {
      super(flyweight);
    }

    public abstract Builder<T> field(Flyweight.Builder.Visitor visitor);

    public abstract Builder<T> fields(int fieldCount, Flyweight.Builder.Visitor visitor);

    public abstract Builder<T> fields(int fieldCount, DirectBuffer buffer, int index, int length);
  }
}
