// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.ArrayFW;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.HttpHeaderFW;

public final class HttpDataExFW extends Flyweight {
  public static final int FIELD_OFFSET_TYPE_ID = 0;

  private static final int FIELD_SIZE_TYPE_ID = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_PROMISE = FIELD_OFFSET_TYPE_ID + FIELD_SIZE_TYPE_ID;

  private final ArrayFW<HttpHeaderFW> promiseRO = new ArrayFW<HttpHeaderFW>(new HttpHeaderFW());

  public int typeId() {
    return buffer().getInt(offset() + FIELD_OFFSET_TYPE_ID);
  }

  public ArrayFW<HttpHeaderFW> promise() {
    return promiseRO;
  }

  @Override
  public HttpDataExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    promiseRO.wrap(buffer, offset + FIELD_OFFSET_PROMISE, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public HttpDataExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == promiseRO.tryWrap(buffer, offset + FIELD_OFFSET_PROMISE, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return promiseRO.limit();
  }

  @Override
  public String toString() {
    return String.format("HTTP_DATA_EX [typeId=%d, promise=%s]", typeId(), promise());
  }

  public static final class Builder extends Flyweight.Builder<HttpDataExFW> {
    private static final int INDEX_TYPE_ID = 0;

    private static final int INDEX_PROMISE = 1;

    private static final int FIELD_COUNT = 2;

    private final ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> promiseRW = new ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>(new HttpHeaderFW.Builder(), new HttpHeaderFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new HttpDataExFW());
    }

    public Builder typeId(int value) {
      assert lastFieldSet == INDEX_TYPE_ID - 1;
      int newLimit = limit() + FIELD_SIZE_TYPE_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_TYPE_ID;
      limit(newLimit);
      return this;
    }

    public Builder promise(Consumer<ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW>> mutator) {
      assert lastFieldSet == INDEX_PROMISE - 1;
      ArrayFW.Builder<HttpHeaderFW.Builder, HttpHeaderFW> promiseRW = this.promiseRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(promiseRW);
      limit(promiseRW.build().limit());
      lastFieldSet = INDEX_PROMISE;
      return this;
    }

    public Builder promiseItem(Consumer<HttpHeaderFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_PROMISE - 1;
      if (lastFieldSet < INDEX_PROMISE) {
        promiseRW.wrap(buffer(), limit(), maxLimit());
      }
      promiseRW.item(mutator);
      limit(promiseRW.build().limit());
      lastFieldSet = INDEX_PROMISE;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public HttpDataExFW build() {
      if (lastFieldSet < INDEX_PROMISE) {
        promise(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
