// TODO: license
package org.reaktivity.nukleus.oauth.internal.types.control;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.nukleus.oauth.internal.types.Flyweight;
import org.reaktivity.nukleus.oauth.internal.types.StringFW;

public final class OAuthResolveExFW extends Flyweight {
  public static final int FIELD_OFFSET_ISSUER = 0;

  public static final int FIELD_OFFSET_AUDIENCE = 0;

  private final StringFW issuerRO = new StringFW();

  private final StringFW audienceRO = new StringFW();

  public StringFW issuer() {
    return issuerRO;
  }

  public StringFW audience() {
    return audienceRO;
  }

  @Override
  public OAuthResolveExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    issuerRO.wrap(buffer, offset + FIELD_OFFSET_ISSUER, maxLimit);
    audienceRO.wrap(buffer, issuerRO.limit() + FIELD_OFFSET_AUDIENCE, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public OAuthResolveExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == issuerRO.tryWrap(buffer, offset + FIELD_OFFSET_ISSUER, maxLimit)) {
      return null;
    }
    if (null == audienceRO.tryWrap(buffer, issuerRO.limit() + FIELD_OFFSET_AUDIENCE, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return audienceRO.limit();
  }

  @Override
  public String toString() {
    return String.format("OAUTH_RESOLVE_EX [issuer=%s, audience=%s]", issuerRO.asString(), audienceRO.asString());
  }

  public static final class Builder extends Flyweight.Builder<OAuthResolveExFW> {
    private static final int INDEX_ISSUER = 0;

    private static final int INDEX_AUDIENCE = 1;

    private static final int FIELD_COUNT = 2;

    private final StringFW.Builder issuerRW = new StringFW.Builder();

    private final StringFW.Builder audienceRW = new StringFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new OAuthResolveExFW());
    }

    private StringFW.Builder issuer() {
      assert lastFieldSet == INDEX_ISSUER - 1;
      return issuerRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder issuer(String value) {
      StringFW.Builder issuerRW = issuer();
      issuerRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_ISSUER;
      limit(issuerRW.build().limit());
      return this;
    }

    public Builder issuer(StringFW value) {
      StringFW.Builder issuerRW = issuer();
      issuerRW.set(value);
      lastFieldSet = INDEX_ISSUER;
      limit(issuerRW.build().limit());
      return this;
    }

    public Builder issuer(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder issuerRW = issuer();
      issuerRW.set(buffer, offset, length);
      lastFieldSet = INDEX_ISSUER;
      limit(issuerRW.build().limit());
      return this;
    }

    private StringFW.Builder audience() {
      assert lastFieldSet == INDEX_AUDIENCE - 1;
      return audienceRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder audience(String value) {
      StringFW.Builder audienceRW = audience();
      audienceRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_AUDIENCE;
      limit(audienceRW.build().limit());
      return this;
    }

    public Builder audience(StringFW value) {
      StringFW.Builder audienceRW = audience();
      audienceRW.set(value);
      lastFieldSet = INDEX_AUDIENCE;
      limit(audienceRW.build().limit());
      return this;
    }

    public Builder audience(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder audienceRW = audience();
      audienceRW.set(buffer, offset, length);
      lastFieldSet = INDEX_AUDIENCE;
      limit(audienceRW.build().limit());
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public OAuthResolveExFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
